<?php

use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Auth\RegisterController;
use App\Http\Controllers\Auth\PasswordResetLinkController;
use App\Http\Controllers\Auth\NewPasswordController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\AccountController;
use App\Http\Controllers\ItemController;
use App\Http\Controllers\PartyController;
use App\Http\Controllers\PurchaseController;
use App\Http\Controllers\SaleController;
use App\Http\Controllers\VoucherController;
use App\Http\Controllers\ProductionController;
use App\Http\Controllers\ContractController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\BackupController;
use App\Http\Controllers\SettingController;
use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
*/

// Redirect root to login or dashboard
Route::get('/', function () {
    return auth()->check() ? redirect()->route('dashboard') : redirect()->route('login');
});

/*
|--------------------------------------------------------------------------
| Authentication Routes
|--------------------------------------------------------------------------
*/
Route::middleware('guest')->group(function () {
    Route::get('login', [LoginController::class, 'create'])->name('login');
    Route::post('login', [LoginController::class, 'store']);
    
    Route::get('register', [RegisterController::class, 'create'])->name('register');
    Route::post('register', [RegisterController::class, 'store']);
    
    Route::get('forgot-password', [PasswordResetLinkController::class, 'create'])->name('password.request');
    Route::post('forgot-password', [PasswordResetLinkController::class, 'store'])->name('password.email');
    
    Route::get('reset-password/{token}', [NewPasswordController::class, 'create'])->name('password.reset');
    Route::post('reset-password', [NewPasswordController::class, 'store'])->name('password.store');
});

Route::post('logout', [LoginController::class, 'destroy'])->middleware('auth')->name('logout');

/*
|--------------------------------------------------------------------------
| Protected Routes
|--------------------------------------------------------------------------
*/
Route::middleware('auth')->group(function () {
    
    // Dashboard
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    
    // Profile
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
    
    /*
    |--------------------------------------------------------------------------
    | CODE Menu - Master Data
    |--------------------------------------------------------------------------
    */
    
    // Chart of Accounts
    Route::resource('accounts', AccountController::class);
    Route::get('/accounts-next-code', [AccountController::class, 'getNextCode'])->name('accounts.next-code');
    Route::get('/accounts-sub-types', [AccountController::class, 'getSubTypes'])->name('accounts.sub-types');
    
    // Items / Products
    Route::resource('items', ItemController::class);
    
    // Parties (Customers & Suppliers)
    Route::resource('parties', PartyController::class);
    Route::get('/parties-purchase', [PartyController::class, 'purchaseParties'])->name('parties.purchase');
    Route::get('/parties-sale', [PartyController::class, 'saleParties'])->name('parties.sale');
    
    /*
    |--------------------------------------------------------------------------
    | TRANSACTION Menu
    |--------------------------------------------------------------------------
    */
    
    // Purchases
    Route::resource('purchases', PurchaseController::class);
    Route::get('/purchases/{purchase}/print', [PurchaseController::class, 'print'])->name('purchases.print');
    
    // Sales
    Route::resource('sales', SaleController::class);
    Route::get('/sales/{sale}/print', [SaleController::class, 'print'])->name('sales.print');
    
    // Vouchers
    Route::prefix('vouchers')->name('vouchers.')->group(function () {
        // Credit Voucher
        Route::get('/credit', [VoucherController::class, 'creditIndex'])->name('credit.index');
        Route::get('/credit/create', [VoucherController::class, 'creditCreate'])->name('credit.create');
        Route::post('/credit', [VoucherController::class, 'creditStore'])->name('credit.store');
        Route::get('/credit/{voucher}', [VoucherController::class, 'creditShow'])->name('credit.show');
        Route::get('/credit/{voucher}/edit', [VoucherController::class, 'creditEdit'])->name('credit.edit');
        Route::put('/credit/{voucher}', [VoucherController::class, 'creditUpdate'])->name('credit.update');
        Route::delete('/credit/{voucher}', [VoucherController::class, 'creditDestroy'])->name('credit.destroy');
        Route::get('/credit/{voucher}/print', [VoucherController::class, 'creditPrint'])->name('credit.print');
        
        // Debit Voucher
        Route::get('/debit', [VoucherController::class, 'debitIndex'])->name('debit.index');
        Route::get('/debit/create', [VoucherController::class, 'debitCreate'])->name('debit.create');
        Route::post('/debit', [VoucherController::class, 'debitStore'])->name('debit.store');
        Route::get('/debit/{voucher}', [VoucherController::class, 'debitShow'])->name('debit.show');
        Route::get('/debit/{voucher}/edit', [VoucherController::class, 'debitEdit'])->name('debit.edit');
        Route::put('/debit/{voucher}', [VoucherController::class, 'debitUpdate'])->name('debit.update');
        Route::delete('/debit/{voucher}', [VoucherController::class, 'debitDestroy'])->name('debit.destroy');
        Route::get('/debit/{voucher}/print', [VoucherController::class, 'debitPrint'])->name('debit.print');
        
        // Journal Voucher
        Route::get('/journal', [VoucherController::class, 'journalIndex'])->name('journal.index');
        Route::get('/journal/create', [VoucherController::class, 'journalCreate'])->name('journal.create');
        Route::post('/journal', [VoucherController::class, 'journalStore'])->name('journal.store');
        Route::get('/journal/{voucher}', [VoucherController::class, 'journalShow'])->name('journal.show');
        Route::get('/journal/{voucher}/edit', [VoucherController::class, 'journalEdit'])->name('journal.edit');
        Route::put('/journal/{voucher}', [VoucherController::class, 'journalUpdate'])->name('journal.update');
        Route::delete('/journal/{voucher}', [VoucherController::class, 'journalDestroy'])->name('journal.destroy');
        Route::get('/journal/{voucher}/print', [VoucherController::class, 'journalPrint'])->name('journal.print');
    });
    
    // Production
    Route::resource('production', ProductionController::class);
    Route::get('/production/{production}/print', [ProductionController::class, 'print'])->name('production.print');
    
    // Contracts
    Route::resource('contracts', ContractController::class);
    Route::get('/contracts/{contract}/print', [ContractController::class, 'print'])->name('contracts.print');
    Route::get('/contracts-report', [ContractController::class, 'report'])->name('contracts.report');
    Route::get('/contracts-by-party', [ContractController::class, 'getByParty'])->name('contracts.by-party');
    
    /*
    |--------------------------------------------------------------------------
    | REPORT Menu
    |--------------------------------------------------------------------------
    */
    Route::prefix('reports')->name('reports.')->group(function () {
        Route::get('/daily-book', [ReportController::class, 'dailyBook'])->name('daily-book');
        Route::get('/journal', [ReportController::class, 'journal'])->name('journal');
        Route::get('/ledger', [ReportController::class, 'ledger'])->name('ledger');
        Route::get('/ledger-code-range', [ReportController::class, 'ledgerCodeRange'])->name('ledger-code-range');
        Route::get('/trial-balance', [ReportController::class, 'trialBalance'])->name('trial-balance');
        Route::get('/trial-balance-specific', [ReportController::class, 'trialBalanceSpecific'])->name('trial-balance-specific');
        Route::get('/cash-book', [ReportController::class, 'cashBook'])->name('cash-book');
        Route::get('/cash-flow', [ReportController::class, 'cashFlow'])->name('cash-flow');
        Route::get('/profit-loss', [ReportController::class, 'profitLoss'])->name('profit-loss');
        Route::get('/balance-sheet', [ReportController::class, 'balanceSheet'])->name('balance-sheet');
        Route::get('/stock', [ReportController::class, 'stock'])->name('stock');
        Route::get('/party-balance', [ReportController::class, 'partyBalance'])->name('party-balance');
        Route::get('/bill-wise-purchase', [ReportController::class, 'billWisePurchase'])->name('bill-wise-purchase');
        Route::get('/bill-wise-sale', [ReportController::class, 'billWiseSale'])->name('bill-wise-sale');
        Route::get('/aging', [ReportController::class, 'aging'])->name('aging');
        Route::get('/chart-of-accounts', [ReportController::class, 'chartOfAccounts'])->name('chart-of-accounts');
        Route::get('/general-ledger', [ReportController::class, 'generalLedger'])->name('general-ledger');
    });
    
    /*
    |--------------------------------------------------------------------------
    | Users & Roles
    |--------------------------------------------------------------------------
    */
    Route::resource('users', UserController::class);
    Route::resource('roles', RoleController::class);
    
    /*
    |--------------------------------------------------------------------------
    | Backup
    |--------------------------------------------------------------------------
    */
    Route::prefix('backup')->name('backup.')->group(function () {
        Route::get('/', [BackupController::class, 'index'])->name('list');
        Route::post('/create', [BackupController::class, 'create'])->name('create');
        Route::get('/restore', [BackupController::class, 'restoreForm'])->name('restore');
        Route::post('/restore', [BackupController::class, 'restore'])->name('restore.post');
        Route::get('/download/{backup}', [BackupController::class, 'download'])->name('download');
        Route::delete('/{backup}', [BackupController::class, 'destroy'])->name('destroy');
    });
    
    /*
    |--------------------------------------------------------------------------
    | Settings
    |--------------------------------------------------------------------------
    */
    Route::prefix('settings')->name('settings.')->group(function () {
        Route::get('/', [SettingController::class, 'index'])->name('index');
        Route::get('/company', [SettingController::class, 'company'])->name('company');
        Route::put('/company', [SettingController::class, 'updateCompany'])->name('company.update');
        Route::get('/financial-year', [SettingController::class, 'financialYear'])->name('financial-year');
        Route::put('/financial-year', [SettingController::class, 'updateFinancialYear'])->name('financial-year.update');
    });
});
