@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-money-check-alt"></i> Debit Vouchers (Payments)</h3>
        <a href="{{ route('vouchers.debit.create') }}" class="btn btn-primary">
            <i class="fas fa-plus"></i> New Debit Voucher
        </a>
    </div>
    <div class="card-body">
        @if(session('success'))
        <div class="alert alert-success">
            <i class="fas fa-check-circle"></i> {{ session('success') }}
        </div>
        @endif

        @if(session('error'))
        <div class="alert alert-danger">
            <i class="fas fa-exclamation-circle"></i> {{ session('error') }}
        </div>
        @endif

        <!-- Filter Form -->
        <form method="GET" action="{{ route('vouchers.debit.index') }}" class="mb-4">
            <div class="form-row">
                <div class="form-group" style="flex: 0 0 150px;">
                    <label class="form-label">From Date</label>
                    <input type="date" name="from_date" class="form-control" value="{{ request('from_date') }}">
                </div>
                <div class="form-group" style="flex: 0 0 150px;">
                    <label class="form-label">To Date</label>
                    <input type="date" name="to_date" class="form-control" value="{{ request('to_date') }}">
                </div>
                <div class="form-group" style="flex: 1;">
                    <label class="form-label">Search</label>
                    <input type="text" name="search" class="form-control" placeholder="Voucher No / Narration..." value="{{ request('search') }}">
                </div>
                <div class="form-group" style="flex: 0 0 auto; display: flex; align-items: flex-end; gap: 0.5rem;">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-search"></i> Search
                    </button>
                    <a href="{{ route('vouchers.debit.index') }}" class="btn btn-outline">
                        <i class="fas fa-redo"></i> Reset
                    </a>
                </div>
            </div>
        </form>

        <!-- Vouchers Table -->
        <table>
            <thead>
                <tr>
                    <th style="width: 120px;">Voucher No.</th>
                    <th style="width: 100px;">Date</th>
                    <th>Account (Paid To)</th>
                    <th>From</th>
                    <th class="text-right" style="width: 120px;">Amount</th>
                    <th style="width: 200px;">Narration</th>
                    <th style="width: 120px;">Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($vouchers as $voucher)
                <tr>
                    <td>
                        <a href="{{ route('vouchers.debit.show', $voucher) }}">{{ $voucher->voucher_no }}</a>
                    </td>
                    <td>{{ $voucher->date->format('d-M-Y') }}</td>
                    <td>
                        @php 
                            $debitEntry = $voucher->entries->where('debit', '>', 0)->first();
                        @endphp
                        @if($debitEntry)
                            <a href="{{ route('accounts.show', $debitEntry->account) }}">{{ $debitEntry->account->name }}</a>
                        @endif
                    </td>
                    <td>
                        @php 
                            $creditEntry = $voucher->entries->where('credit', '>', 0)->first();
                        @endphp
                        @if($creditEntry)
                            <span class="badge badge-info">{{ $creditEntry->account->name }}</span>
                        @endif
                    </td>
                    <td class="text-right">
                        <strong class="text-danger">Rs. {{ number_format($voucher->amount, 2) }}</strong>
                    </td>
                    <td>
                        <small>{{ Str::limit($voucher->narration, 30) }}</small>
                    </td>
                    <td>
                        <div style="display: flex; gap: 0.25rem;">
                            <a href="{{ route('vouchers.debit.show', $voucher) }}" class="btn btn-outline" style="padding: 0.25rem 0.5rem; font-size: 0.75rem;">
                                <i class="fas fa-eye"></i>
                            </a>
                            <a href="{{ route('vouchers.debit.print', $voucher) }}" class="btn btn-outline" style="padding: 0.25rem 0.5rem; font-size: 0.75rem;" target="_blank">
                                <i class="fas fa-print"></i>
                            </a>
                            <form action="{{ route('vouchers.debit.destroy', $voucher) }}" method="POST" 
                                  onsubmit="return confirm('Delete this voucher?');" style="display: inline;">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-outline" style="padding: 0.25rem 0.5rem; font-size: 0.75rem; color: var(--danger-color);">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </div>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="7" class="text-center">No debit vouchers found</td>
                </tr>
                @endforelse
            </tbody>
            @if($vouchers->count() > 0)
            <tfoot>
                <tr>
                    <td colspan="4" class="text-right"><strong>Total:</strong></td>
                    <td class="text-right"><strong class="text-danger">Rs. {{ number_format($vouchers->sum('amount'), 2) }}</strong></td>
                    <td colspan="2"></td>
                </tr>
            </tfoot>
            @endif
        </table>

        <!-- Pagination -->
        <div style="margin-top: 1rem;">
            {{ $vouchers->links() }}
        </div>
    </div>
</div>
@endsection
