@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-hand-holding-usd"></i> Credit Vouchers (Receipts)</h3>
        <a href="{{ route('vouchers.credit.create') }}" class="btn btn-primary">
            <i class="fas fa-plus"></i> New Credit Voucher
        </a>
    </div>
    <div class="card-body">
        @if(session('success'))
            <div class="alert alert-success">
                <i class="fas fa-check-circle"></i> {{ session('success') }}
            </div>
        @endif
        
        @if(session('error'))
            <div class="alert alert-danger">
                <i class="fas fa-exclamation-circle"></i> {{ session('error') }}
            </div>
        @endif

        <!-- Filters -->
        <form action="{{ route('vouchers.credit.index') }}" method="GET">
            <div class="form-row mb-4">
                <div class="form-group" style="flex: 0 0 150px;">
                    <label class="form-label">From Date</label>
                    <input type="date" class="form-control" name="from_date" value="{{ request('from_date', date('Y-m-01')) }}">
                </div>
                <div class="form-group" style="flex: 0 0 150px;">
                    <label class="form-label">To Date</label>
                    <input type="date" class="form-control" name="to_date" value="{{ request('to_date', date('Y-m-d')) }}">
                </div>
                <div class="form-group" style="flex: 1;">
                    <label class="form-label">Search</label>
                    <input type="text" class="form-control" name="search" value="{{ request('search') }}" placeholder="Voucher No...">
                </div>
                <div class="form-group" style="flex: 0 0 100px; display: flex; align-items: flex-end;">
                    <button type="submit" class="btn btn-primary" style="width: 100%;">
                        <i class="fas fa-search"></i> Search
                    </button>
                </div>
            </div>
        </form>

        <div class="table-responsive">
            <table>
                <thead>
                    <tr>
                        <th>Voucher No.</th>
                        <th>Date</th>
                        <th>Account</th>
                        <th class="text-right">Amount</th>
                        <th>Narration</th>
                        <th class="text-center">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($vouchers as $voucher)
                        <tr>
                            <td>
                                <a href="{{ route('vouchers.credit.show', $voucher) }}" style="font-weight: 600; color: var(--success-color);">
                                    {{ $voucher->voucher_no }}
                                </a>
                            </td>
                            <td>{{ $voucher->date->format('d-M-Y') }}</td>
                            <td>
                                @php
                                    $creditEntry = $voucher->entries->where('credit', '>', 0)->first();
                                @endphp
                                {{ $creditEntry->account->name ?? '-' }}
                            </td>
                            <td class="text-right"><strong class="text-success">Rs. {{ number_format($voucher->amount, 2) }}</strong></td>
                            <td>{{ Str::limit($voucher->narration, 40) ?? '-' }}</td>
                            <td class="text-center">
                                <a href="{{ route('vouchers.credit.show', $voucher) }}" class="btn btn-outline" style="padding: 0.25rem 0.5rem;" title="View">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="{{ route('vouchers.credit.print', $voucher) }}" class="btn btn-outline" style="padding: 0.25rem 0.5rem;" title="Print" target="_blank">
                                    <i class="fas fa-print"></i>
                                </a>
                                <form action="{{ route('vouchers.credit.destroy', $voucher) }}" method="POST" style="display: inline;">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-outline" style="padding: 0.25rem 0.5rem; color: var(--danger-color);" 
                                            onclick="return confirm('Delete this voucher? This will reverse ledger entries.')" title="Delete">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="text-center text-muted" style="padding: 3rem;">
                                <i class="fas fa-hand-holding-usd" style="font-size: 3rem; display: block; margin-bottom: 1rem; opacity: 0.5;"></i>
                                <p style="margin: 0;">No credit vouchers found. <a href="{{ route('vouchers.credit.create') }}">Create your first receipt voucher</a></p>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        @if($vouchers->hasPages())
            <div style="margin-top: 1rem;">
                {{ $vouchers->links() }}
            </div>
        @endif

        <!-- Summary -->
        <div style="display: flex; justify-content: flex-end; margin-top: 1rem; padding-top: 1rem; border-top: 1px solid var(--border-color);">
            <table style="width: 300px; border: 1px solid var(--border-color); border-radius: var(--border-radius);">
                <tr>
                    <td style="padding: 0.5rem 1rem; border-bottom: 1px solid var(--border-color);">Total Vouchers:</td>
                    <td style="padding: 0.5rem 1rem; border-bottom: 1px solid var(--border-color); text-align: right;"><strong>{{ $vouchers->total() }}</strong></td>
                </tr>
                <tr style="background: var(--light-bg);">
                    <td style="padding: 0.75rem 1rem;"><strong>Total Receipts:</strong></td>
                    <td style="padding: 0.75rem 1rem; text-align: right;"><strong class="text-success">Rs. {{ number_format($totals, 2) }}</strong></td>
                </tr>
            </table>
        </div>
    </div>
</div>
@endsection
