@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-hand-holding-usd"></i> New Credit Voucher (Receipt)</h3>
        <a href="{{ route('vouchers.credit.index') }}" class="btn btn-outline">
            <i class="fas fa-arrow-left"></i> Back
        </a>
    </div>
    <div class="card-body">
        @if ($errors->any())
            <div class="alert alert-danger">
                <strong><i class="fas fa-exclamation-circle"></i> Please fix the following errors:</strong>
                <ul style="margin: 0.5rem 0 0 1rem;">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        
        @if(session('error'))
            <div class="alert alert-danger">
                <i class="fas fa-exclamation-circle"></i> {{ session('error') }}
            </div>
        @endif

        <div class="alert alert-info" style="margin-bottom: 1rem;">
            <i class="fas fa-info-circle"></i> 
            <strong>Credit Voucher:</strong> Used for recording money received (receipts). Cash/Bank will be debited, and the selected account will be credited.
        </div>

        <form action="{{ route('vouchers.credit.store') }}" method="POST" id="voucherForm">
            @csrf
            
            <div class="form-row">
                <div class="form-group" style="flex: 0 0 180px;">
                    <label class="form-label" for="voucher_no">Voucher No.</label>
                    <input type="text" class="form-control" id="voucher_no" 
                           value="{{ $nextVoucherNo }}" readonly style="background: var(--light-bg);">
                </div>

                <div class="form-group" style="flex: 0 0 150px;">
                    <label class="form-label" for="date">Date <span class="text-danger">*</span></label>
                    <input type="date" class="form-control @error('date') is-invalid @enderror" id="date" name="date" 
                           value="{{ old('date', date('Y-m-d')) }}" required>
                </div>

                <div class="form-group" style="flex: 0 0 180px;">
                    <label class="form-label" for="amount">Amount <span class="text-danger">*</span></label>
                    <input type="number" class="form-control @error('amount') is-invalid @enderror" id="amount" name="amount" 
                           step="0.01" min="0.01" value="{{ old('amount') }}" required placeholder="0.00">
                </div>
            </div>

            <div class="form-row">
                <div class="form-group" style="flex: 1;">
                    <label class="form-label" for="account_id">Received From (Credit Account) <span class="text-danger">*</span></label>
                    <select class="form-control @error('account_id') is-invalid @enderror" id="account_id" name="account_id" required>
                        <option value="">Select Account</option>
                        @foreach($accounts as $account)
                            <option value="{{ $account->id }}" {{ old('account_id') == $account->id ? 'selected' : '' }}>
                                {{ $account->code }} - {{ $account->name }} ({{ $account->type }})
                            </option>
                        @endforeach
                    </select>
                    <small class="text-muted">This account will be CREDITED (e.g., Party, Income, Loan received)</small>
                </div>

                <div class="form-group" style="flex: 1;">
                    <label class="form-label" for="cash_bank_id">Received In (Cash/Bank) <span class="text-danger">*</span></label>
                    <select class="form-control @error('cash_bank_id') is-invalid @enderror" id="cash_bank_id" name="cash_bank_id" required>
                        <option value="">Select Cash/Bank Account</option>
                        @foreach($cashBankAccounts as $account)
                            <option value="{{ $account->id }}" {{ old('cash_bank_id') == $account->id ? 'selected' : '' }}>
                                {{ $account->code }} - {{ $account->name }}
                            </option>
                        @endforeach
                    </select>
                    <small class="text-muted">This account will be DEBITED (Cash/Bank increases)</small>
                </div>
            </div>

            <div class="form-group">
                <label class="form-label" for="narration">Narration / Description</label>
                <textarea class="form-control" id="narration" name="narration" rows="3" 
                          placeholder="Enter details about this receipt...">{{ old('narration') }}</textarea>
            </div>

            <!-- Preview -->
            <div class="card mt-3" style="border: 1px solid var(--border-color);">
                <div class="card-header" style="background: var(--light-bg); padding: 0.75rem 1rem;">
                    <h4 style="font-size: 0.9375rem; font-weight: 600; margin: 0;">
                        <i class="fas fa-book"></i> Ledger Entry Preview
                    </h4>
                </div>
                <div class="card-body" style="padding: 0;">
                    <table>
                        <thead>
                            <tr>
                                <th>Account</th>
                                <th class="text-right" style="width: 150px;">Debit</th>
                                <th class="text-right" style="width: 150px;">Credit</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td><span id="debitAccountName">Cash/Bank Account</span></td>
                                <td class="text-right text-success"><strong id="previewDebit">Rs. 0.00</strong></td>
                                <td class="text-right">-</td>
                            </tr>
                            <tr>
                                <td><span id="creditAccountName">Selected Account</span></td>
                                <td class="text-right">-</td>
                                <td class="text-right text-danger"><strong id="previewCredit">Rs. 0.00</strong></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>

            <div style="display: flex; gap: 0.5rem; margin-top: 1.5rem; padding-top: 1rem; border-top: 1px solid var(--border-color);">
                <button type="submit" class="btn btn-success">
                    <i class="fas fa-save"></i> Save Credit Voucher
                </button>
                <a href="{{ route('vouchers.credit.index') }}" class="btn btn-outline">
                    Cancel
                </a>
            </div>
        </form>
    </div>
</div>

<script>
    // Update preview
    document.getElementById('amount').addEventListener('input', updatePreview);
    document.getElementById('account_id').addEventListener('change', updatePreview);
    document.getElementById('cash_bank_id').addEventListener('change', updatePreview);
    
    function updatePreview() {
        const amount = parseFloat(document.getElementById('amount').value) || 0;
        const formatted = 'Rs. ' + amount.toLocaleString('en-PK', {minimumFractionDigits: 2, maximumFractionDigits: 2});
        
        document.getElementById('previewDebit').textContent = formatted;
        document.getElementById('previewCredit').textContent = formatted;
        
        const debitSelect = document.getElementById('cash_bank_id');
        const creditSelect = document.getElementById('account_id');
        
        document.getElementById('debitAccountName').textContent = 
            debitSelect.options[debitSelect.selectedIndex]?.text || 'Cash/Bank Account';
        document.getElementById('creditAccountName').textContent = 
            creditSelect.options[creditSelect.selectedIndex]?.text || 'Selected Account';
    }
</script>
@endsection
