@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-cogs"></i> Settings</h3>
    </div>
    <div class="card-body">
        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(280px, 1fr)); gap: 1.5rem;">
            
            <!-- Company Settings -->
            <a href="{{ route('settings.company') }}" style="text-decoration: none; color: inherit;">
                <div style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); padding: 1.5rem; border-radius: 12px; color: white; transition: transform 0.2s, box-shadow 0.2s;">
                    <div style="display: flex; align-items: center; gap: 1rem;">
                        <div style="width: 60px; height: 60px; background: rgba(255,255,255,0.2); border-radius: 12px; display: flex; align-items: center; justify-content: center;">
                            <i class="fas fa-building" style="font-size: 1.5rem;"></i>
                        </div>
                        <div>
                            <h4 style="margin: 0 0 0.25rem 0; font-size: 1.25rem;">Company Profile</h4>
                            <p style="margin: 0; opacity: 0.9; font-size: 0.875rem;">Name, address, logo, contact info</p>
                        </div>
                    </div>
                </div>
            </a>

            <!-- Financial Year Settings -->
            <a href="{{ route('settings.financial-year') }}" style="text-decoration: none; color: inherit;">
                <div style="background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%); padding: 1.5rem; border-radius: 12px; color: white; transition: transform 0.2s, box-shadow 0.2s;">
                    <div style="display: flex; align-items: center; gap: 1rem;">
                        <div style="width: 60px; height: 60px; background: rgba(255,255,255,0.2); border-radius: 12px; display: flex; align-items: center; justify-content: center;">
                            <i class="fas fa-calendar-alt" style="font-size: 1.5rem;"></i>
                        </div>
                        <div>
                            <h4 style="margin: 0 0 0.25rem 0; font-size: 1.25rem;">Financial Year</h4>
                            <p style="margin: 0; opacity: 0.9; font-size: 0.875rem;">Start date, end date, periods</p>
                        </div>
                    </div>
                </div>
            </a>

            <!-- Currency Settings -->
            <div style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%); padding: 1.5rem; border-radius: 12px; color: white; opacity: 0.7;">
                <div style="display: flex; align-items: center; gap: 1rem;">
                    <div style="width: 60px; height: 60px; background: rgba(255,255,255,0.2); border-radius: 12px; display: flex; align-items: center; justify-content: center;">
                        <i class="fas fa-rupee-sign" style="font-size: 1.5rem;"></i>
                    </div>
                    <div>
                        <h4 style="margin: 0 0 0.25rem 0; font-size: 1.25rem;">Currency</h4>
                        <p style="margin: 0; opacity: 0.9; font-size: 0.875rem;">Currency symbol, format <span class="badge" style="background: rgba(255,255,255,0.3); font-size: 0.7rem;">Coming Soon</span></p>
                    </div>
                </div>
            </div>

            <!-- Backup Settings -->
            <div style="background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%); padding: 1.5rem; border-radius: 12px; color: white; opacity: 0.7;">
                <div style="display: flex; align-items: center; gap: 1rem;">
                    <div style="width: 60px; height: 60px; background: rgba(255,255,255,0.2); border-radius: 12px; display: flex; align-items: center; justify-content: center;">
                        <i class="fas fa-database" style="font-size: 1.5rem;"></i>
                    </div>
                    <div>
                        <h4 style="margin: 0 0 0.25rem 0; font-size: 1.25rem;">Backup & Restore</h4>
                        <p style="margin: 0; opacity: 0.9; font-size: 0.875rem;">Database backup <span class="badge" style="background: rgba(255,255,255,0.3); font-size: 0.7rem;">Coming Soon</span></p>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>

<style>
    .card-body a > div:hover {
        transform: translateY(-3px);
        box-shadow: 0 10px 30px rgba(0,0,0,0.2);
    }
</style>
@endsection
