@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-building"></i> Company Profile Settings</h3>
        <a href="{{ route('settings.index') }}" class="btn btn-outline">
            <i class="fas fa-arrow-left"></i> Back to Settings
        </a>
    </div>
    <div class="card-body">
        @if(session('success'))
            <div style="background-color: #d4edda; border: 1px solid #c3e6cb; color: #155724; padding: 1rem; border-radius: 4px; margin-bottom: 1rem;">
                <i class="fas fa-check-circle"></i> {{ session('success') }}
            </div>
        @endif

        <form action="{{ route('settings.company.update') }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')

            <div class="form-row">
                <!-- Logo Preview -->
                <div style="flex: 0 0 200px; text-align: center;">
                    <label class="form-label">Company Logo</label>
                    <div style="width: 150px; height: 150px; border: 2px dashed var(--border-color); border-radius: 8px; display: flex; align-items: center; justify-content: center; margin: 0 auto 1rem; overflow: hidden; background: #f8f9fa;">
                        @if($company->logo)
                            <img src="{{ asset('storage/' . $company->logo) }}" alt="Logo" style="max-width: 100%; max-height: 100%;">
                        @else
                            <i class="fas fa-image" style="font-size: 3rem; color: #ccc;"></i>
                        @endif
                    </div>
                    <input type="file" class="form-control" id="logo" name="logo" accept="image/*" style="font-size: 0.875rem;">
                    @error('logo')
                        <div class="text-danger" style="font-size: 0.85rem;">{{ $message }}</div>
                    @enderror
                </div>

                <!-- Company Details -->
                <div style="flex: 1;">
                    <div class="form-group">
                        <label class="form-label" for="name">Company Name <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="name" name="name" value="{{ old('name', $company->name) }}" required style="font-size: 1.1rem; font-weight: 600;">
                        @error('name')
                            <div class="text-danger" style="font-size: 0.85rem;">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label class="form-label" for="address">Address</label>
                        <textarea class="form-control" id="address" name="address" rows="2" placeholder="Enter company address...">{{ old('address', $company->address) }}</textarea>
                        @error('address')
                            <div class="text-danger" style="font-size: 0.85rem;">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="form-row">
                <div class="form-group" style="flex: 1;">
                    <label class="form-label" for="phone">Phone Number</label>
                    <input type="text" class="form-control" id="phone" name="phone" value="{{ old('phone', $company->phone) }}" placeholder="+92-xxx-xxxxxxx">
                    @error('phone')
                        <div class="text-danger" style="font-size: 0.85rem;">{{ $message }}</div>
                    @enderror
                </div>
                <div class="form-group" style="flex: 1;">
                    <label class="form-label" for="email">Email Address</label>
                    <input type="email" class="form-control" id="email" name="email" value="{{ old('email', $company->email) }}" placeholder="company@example.com">
                    @error('email')
                        <div class="text-danger" style="font-size: 0.85rem;">{{ $message }}</div>
                    @enderror
                </div>
                <div class="form-group" style="flex: 1;">
                    <label class="form-label" for="website">Website</label>
                    <input type="url" class="form-control" id="website" name="website" value="{{ old('website', $company->website) }}" placeholder="https://www.example.com">
                    @error('website')
                        <div class="text-danger" style="font-size: 0.85rem;">{{ $message }}</div>
                    @enderror
                </div>
            </div>

            <!-- Preview Card -->
            <div style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); padding: 1.5rem; border-radius: 12px; color: white; margin-top: 1.5rem;">
                <h4 style="margin: 0 0 1rem 0;"><i class="fas fa-eye"></i> Print Header Preview</h4>
                <div style="background: white; color: #333; padding: 1.5rem; border-radius: 8px; text-align: center;">
                    <h2 style="margin: 0 0 0.25rem 0; font-size: 1.5rem;" id="previewName">{{ $company->name ?: 'Company Name' }}</h2>
                    <p style="margin: 0 0 0.25rem 0; font-size: 0.9rem;" id="previewAddress">{{ $company->address ?: 'Company Address' }}</p>
                    <p style="margin: 0; font-size: 0.85rem; color: #666;">
                        <span id="previewPhone">{{ $company->phone ?: 'Phone' }}</span> | 
                        <span id="previewEmail">{{ $company->email ?: 'Email' }}</span>
                    </p>
                </div>
            </div>

            <div style="display: flex; gap: 0.5rem; margin-top: 1.5rem; padding-top: 1rem; border-top: 1px solid var(--border-color);">
                <button type="submit" class="btn btn-success">
                    <i class="fas fa-save"></i> Save Company Settings
                </button>
                <a href="{{ route('settings.index') }}" class="btn btn-outline">
                    <i class="fas fa-times"></i> Cancel
                </a>
            </div>
        </form>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Live preview updates
    document.getElementById('name').addEventListener('input', function() {
        document.getElementById('previewName').textContent = this.value || 'Company Name';
    });
    document.getElementById('address').addEventListener('input', function() {
        document.getElementById('previewAddress').textContent = this.value || 'Company Address';
    });
    document.getElementById('phone').addEventListener('input', function() {
        document.getElementById('previewPhone').textContent = this.value || 'Phone';
    });
    document.getElementById('email').addEventListener('input', function() {
        document.getElementById('previewEmail').textContent = this.value || 'Email';
    });
});
</script>
@endsection
