@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-balance-scale"></i> Trial Balance</h3>
        <button class="btn btn-outline" onclick="window.print()">
            <i class="fas fa-print"></i> Print
        </button>
    </div>
    <div class="card-body">
        <!-- Filter -->
        <form method="GET" action="{{ route('reports.trial-balance') }}" class="mb-4">
            <div class="form-row">
                <div class="form-group" style="flex: 0 0 180px;">
                    <label class="form-label">As On Date</label>
                    <input type="date" name="as_on_date" class="form-control" value="{{ $asOnDate }}">
                </div>
                <div class="form-group" style="flex: 0 0 auto; display: flex; align-items: flex-end;">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-search"></i> Generate
                    </button>
                </div>
            </div>
        </form>

        <div class="alert alert-info">
            <strong>Trial Balance as on:</strong> {{ \Carbon\Carbon::parse($asOnDate)->format('d F Y') }}
        </div>

        <table>
            <thead>
                <tr>
                    <th style="width: 80px;">Code</th>
                    <th>Account Name</th>
                    <th style="width: 100px;">Type</th>
                    <th class="text-right" style="width: 150px;">Debit Balance</th>
                    <th class="text-right" style="width: 150px;">Credit Balance</th>
                </tr>
            </thead>
            <tbody>
                @forelse($accounts as $account)
                <tr>
                    <td>{{ $account->code }}</td>
                    <td>
                        <a href="{{ route('reports.ledger', ['account_id' => $account->id]) }}">
                            {{ $account->name }}
                        </a>
                    </td>
                    <td>
                        <small class="badge badge-secondary">{{ $account->type }}</small>
                    </td>
                    <td class="text-right">
                        @if($account->debit_balance > 0)
                            {{ number_format($account->debit_balance, 2) }}
                        @else
                            -
                        @endif
                    </td>
                    <td class="text-right">
                        @if($account->credit_balance > 0)
                            {{ number_format($account->credit_balance, 2) }}
                        @else
                            -
                        @endif
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="5" class="text-center">No account balances found</td>
                </tr>
                @endforelse
            </tbody>
            <tfoot>
                <tr style="background: var(--light-bg); font-weight: 700;">
                    <td colspan="3" class="text-right">Total:</td>
                    <td class="text-right">{{ number_format($totalDebit, 2) }}</td>
                    <td class="text-right">{{ number_format($totalCredit, 2) }}</td>
                </tr>
                <tr style="background: {{ abs($totalDebit - $totalCredit) < 0.01 ? 'var(--success-color)' : 'var(--danger-color)' }}; color: #fff;">
                    <td colspan="3" class="text-right"><strong>Difference:</strong></td>
                    <td colspan="2" class="text-center">
                        <strong>{{ number_format(abs($totalDebit - $totalCredit), 2) }}</strong>
                        @if(abs($totalDebit - $totalCredit) < 0.01)
                            <i class="fas fa-check-circle"></i> Balanced
                        @else
                            <i class="fas fa-exclamation-triangle"></i> Not Balanced
                        @endif
                    </td>
                </tr>
            </tfoot>
        </table>
    </div>
</div>
@endsection
