@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-filter"></i> Trial Balance - Specific Type</h3>
        <button class="btn btn-outline" onclick="window.print()">
            <i class="fas fa-print"></i> Print
        </button>
    </div>
    <div class="card-body">
        <!-- Filter -->
        <form method="GET" action="{{ route('reports.trial-balance-specific') }}" class="mb-4">
            <div class="form-row">
                <div class="form-group" style="flex: 0 0 200px;">
                    <label class="form-label">Account Type</label>
                    <select name="type" class="form-control" required>
                        <option value="">-- Select Type --</option>
                        @foreach($types as $t)
                        <option value="{{ $t }}" {{ $type == $t ? 'selected' : '' }}>{{ $t }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="form-group" style="flex: 0 0 180px;">
                    <label class="form-label">As On Date</label>
                    <input type="date" name="as_on_date" class="form-control" value="{{ $asOnDate }}">
                </div>
                <div class="form-group" style="flex: 0 0 auto; display: flex; align-items: flex-end;">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-search"></i> View
                    </button>
                </div>
            </div>
        </form>

        @if($type)
        <div class="alert alert-info">
            <strong>Account Type:</strong> {{ $type }} |
            <strong>As On:</strong> {{ \Carbon\Carbon::parse($asOnDate)->format('d F Y') }} |
            <strong>Accounts:</strong> {{ $accounts->count() }}
        </div>

        <table>
            <thead>
                <tr>
                    <th style="width: 80px;">Code</th>
                    <th>Account Name</th>
                    <th style="width: 150px;">Sub Type</th>
                    <th class="text-right" style="width: 150px;">Balance</th>
                </tr>
            </thead>
            <tbody>
                @forelse($accounts as $account)
                <tr>
                    <td>{{ $account->code }}</td>
                    <td>
                        <a href="{{ route('reports.ledger', ['account_id' => $account->id]) }}">
                            {{ $account->name }}
                        </a>
                    </td>
                    <td>{{ $account->sub_type }}</td>
                    <td class="text-right">
                        @if($account->balance >= 0)
                            <span class="text-success">{{ number_format($account->balance, 2) }} Dr</span>
                        @else
                            <span class="text-danger">{{ number_format(abs($account->balance), 2) }} Cr</span>
                        @endif
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="4" class="text-center">No accounts found for this type</td>
                </tr>
                @endforelse
            </tbody>
            <tfoot>
                <tr style="background: var(--light-bg); font-weight: 700;">
                    <td colspan="3" class="text-right">Total:</td>
                    <td class="text-right">
                        Rs. {{ number_format($accounts->sum('balance'), 2) }}
                    </td>
                </tr>
            </tfoot>
        </table>
        @else
        <div class="alert alert-warning">
            <i class="fas fa-info-circle"></i> Please select an account type to view.
        </div>
        @endif
    </div>
</div>
@endsection
