@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-chart-pie"></i> Profit & Loss Statement</h3>
        <button class="btn btn-outline" onclick="window.print()">
            <i class="fas fa-print"></i> Print
        </button>
    </div>
    <div class="card-body">
        <!-- Filter -->
        <form method="GET" action="{{ route('reports.profit-loss') }}" class="mb-4">
            <div class="form-row">
                <div class="form-group" style="flex: 0 0 150px;">
                    <label class="form-label">From Date</label>
                    <input type="date" name="from_date" class="form-control" value="{{ $fromDate }}">
                </div>
                <div class="form-group" style="flex: 0 0 150px;">
                    <label class="form-label">To Date</label>
                    <input type="date" name="to_date" class="form-control" value="{{ $toDate }}">
                </div>
                <div class="form-group" style="flex: 0 0 auto; display: flex; align-items: flex-end;">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-search"></i> Generate
                    </button>
                </div>
            </div>
        </form>

        <div class="alert alert-info">
            <strong>Period:</strong> {{ \Carbon\Carbon::parse($fromDate)->format('d M Y') }} to {{ \Carbon\Carbon::parse($toDate)->format('d M Y') }}
        </div>

        <div style="display: flex; gap: 2rem;">
            <!-- Income Section -->
            <div style="flex: 1;">
                <h4 style="background: var(--success-color); color: #fff; padding: 0.75rem; margin: 0;">
                    <i class="fas fa-arrow-down"></i> Income
                </h4>
                <table style="border: 1px solid var(--border-color);">
                    <tbody>
                        @forelse($incomeAccounts as $account)
                        <tr>
                            <td>{{ $account->name }}</td>
                            <td class="text-right" style="width: 130px;">{{ number_format($account->amount, 2) }}</td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="2" class="text-center">No income recorded</td>
                        </tr>
                        @endforelse
                    </tbody>
                    <tfoot>
                        <tr style="background: var(--light-bg); font-weight: 700;">
                            <td>Total Income</td>
                            <td class="text-right text-success">Rs. {{ number_format($totalIncome, 2) }}</td>
                        </tr>
                    </tfoot>
                </table>
            </div>

            <!-- Expense Section -->
            <div style="flex: 1;">
                <h4 style="background: var(--danger-color); color: #fff; padding: 0.75rem; margin: 0;">
                    <i class="fas fa-arrow-up"></i> Expenses
                </h4>
                <table style="border: 1px solid var(--border-color);">
                    <tbody>
                        @forelse($expenseAccounts as $account)
                        <tr>
                            <td>{{ $account->name }}</td>
                            <td class="text-right" style="width: 130px;">{{ number_format($account->amount, 2) }}</td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="2" class="text-center">No expenses recorded</td>
                        </tr>
                        @endforelse
                    </tbody>
                    <tfoot>
                        <tr style="background: var(--light-bg); font-weight: 700;">
                            <td>Total Expenses</td>
                            <td class="text-right text-danger">Rs. {{ number_format($totalExpenses, 2) }}</td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>

        <!-- Net Profit/Loss -->
        <div class="card mt-4" style="background: {{ $netProfit >= 0 ? 'var(--success-color)' : 'var(--danger-color)' }}; color: #fff; padding: 1.5rem; text-align: center;">
            <div style="font-size: 1rem;">{{ $netProfit >= 0 ? 'Net Profit' : 'Net Loss' }}</div>
            <div style="font-size: 2rem; font-weight: 700;">Rs. {{ number_format(abs($netProfit), 2) }}</div>
        </div>
    </div>
</div>
@endsection
