@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-users"></i> Party Balance Report</h3>
        <button class="btn btn-outline" onclick="window.print()">
            <i class="fas fa-print"></i> Print
        </button>
    </div>
    <div class="card-body">
        <!-- Filter -->
        <form method="GET" action="{{ route('reports.party-balance') }}" class="mb-4">
            <div class="form-row">
                <div class="form-group" style="flex: 0 0 200px;">
                    <label class="form-label">Party Type</label>
                    <select name="type" class="form-control">
                        <option value="all" {{ $type == 'all' ? 'selected' : '' }}>All Parties</option>
                        <option value="supplier" {{ $type == 'supplier' ? 'selected' : '' }}>Suppliers Only</option>
                        <option value="customer" {{ $type == 'customer' ? 'selected' : '' }}>Customers Only</option>
                    </select>
                </div>
                <div class="form-group" style="flex: 0 0 auto; display: flex; align-items: flex-end;">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-search"></i> View
                    </button>
                </div>
            </div>
        </form>

        <!-- Summary Cards -->
        <div class="form-row mb-4">
            <div class="form-group" style="flex: 1;">
                <div class="card" style="background: var(--success-color); color: #fff; padding: 1rem; text-align: center;">
                    <div style="font-size: 0.875rem;">Total Receivable</div>
                    <div style="font-size: 1.5rem; font-weight: 700;">Rs. {{ number_format($totalReceivable, 2) }}</div>
                </div>
            </div>
            <div class="form-group" style="flex: 1;">
                <div class="card" style="background: var(--danger-color); color: #fff; padding: 1rem; text-align: center;">
                    <div style="font-size: 0.875rem;">Total Payable</div>
                    <div style="font-size: 1.5rem; font-weight: 700;">Rs. {{ number_format($totalPayable, 2) }}</div>
                </div>
            </div>
            <div class="form-group" style="flex: 1;">
                <div class="card" style="background: var(--primary-color); color: #fff; padding: 1rem; text-align: center;">
                    <div style="font-size: 0.875rem;">Net Position</div>
                    <div style="font-size: 1.5rem; font-weight: 700;">Rs. {{ number_format($totalReceivable - $totalPayable, 2) }}</div>
                </div>
            </div>
        </div>

        <!-- Party Table -->
        <table>
            <thead>
                <tr>
                    <th style="width: 80px;">Code</th>
                    <th>Party Name</th>
                    <th style="width: 100px;">Type</th>
                    <th>Contact</th>
                    <th class="text-right" style="width: 150px;">Balance</th>
                    <th style="width: 100px;">Status</th>
                </tr>
            </thead>
            <tbody>
                @forelse($parties as $party)
                <tr>
                    <td>{{ $party->code }}</td>
                    <td>
                        <a href="{{ route('parties.show', $party) }}">{{ $party->name }}</a>
                    </td>
                    <td>
                        <span class="badge {{ $party->type == 'Supplier' ? 'badge-warning' : 'badge-info' }}">
                            {{ $party->type }}
                        </span>
                    </td>
                    <td>{{ $party->phone }}</td>
                    <td class="text-right">
                        @if($party->balance > 0)
                            <span class="text-success">{{ number_format($party->balance, 2) }} Dr</span>
                        @else
                            <span class="text-danger">{{ number_format(abs($party->balance), 2) }} Cr</span>
                        @endif
                    </td>
                    <td>
                        @if($party->balance > 0)
                            <span class="badge badge-success">Receivable</span>
                        @else
                            <span class="badge badge-danger">Payable</span>
                        @endif
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="6" class="text-center">No parties with outstanding balance</td>
                </tr>
                @endforelse
            </tbody>
            <tfoot>
                <tr style="background: var(--light-bg); font-weight: 700;">
                    <td colspan="4" class="text-right">Total:</td>
                    <td class="text-right">
                        Receivable: {{ number_format($totalReceivable, 2) }}<br>
                        Payable: {{ number_format($totalPayable, 2) }}
                    </td>
                    <td></td>
                </tr>
            </tfoot>
        </table>
    </div>
</div>
@endsection
