@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-book-open"></i> Journal Register</h3>
        <button class="btn btn-outline" onclick="window.print()">
            <i class="fas fa-print"></i> Print
        </button>
    </div>
    <div class="card-body">
        <!-- Filter -->
        <form method="GET" action="{{ route('reports.journal') }}" class="mb-4">
            <div class="form-row">
                <div class="form-group" style="flex: 0 0 150px;">
                    <label class="form-label">From Date</label>
                    <input type="date" name="from_date" class="form-control" value="{{ $fromDate }}">
                </div>
                <div class="form-group" style="flex: 0 0 150px;">
                    <label class="form-label">To Date</label>
                    <input type="date" name="to_date" class="form-control" value="{{ $toDate }}">
                </div>
                <div class="form-group" style="flex: 0 0 auto; display: flex; align-items: flex-end;">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-search"></i> View
                    </button>
                </div>
            </div>
        </form>

        <div class="alert alert-info">
            <strong>Period:</strong> {{ \Carbon\Carbon::parse($fromDate)->format('d M Y') }} to {{ \Carbon\Carbon::parse($toDate)->format('d M Y') }} |
            <strong>Total Vouchers:</strong> {{ $vouchers->count() }}
        </div>

        @forelse($vouchers as $voucher)
        <div class="card mb-3" style="border: 1px solid var(--border-color);">
            <div class="card-header" style="background: var(--light-bg); padding: 0.5rem 1rem;">
                <div style="display: flex; justify-content: space-between; align-items: center;">
                    <div>
                        <strong>{{ $voucher->voucher_no }}</strong>
                        <span class="badge {{ $voucher->type == 'CREDIT' ? 'badge-success' : ($voucher->type == 'DEBIT' ? 'badge-danger' : 'badge-primary') }}">
                            {{ $voucher->type }}
                        </span>
                    </div>
                    <div>
                        <span class="text-muted">{{ $voucher->date->format('d-M-Y') }}</span>
                        <a href="{{ route('vouchers.' . strtolower($voucher->type) . '.show', $voucher) }}" class="btn btn-outline" style="padding: 0.125rem 0.5rem; font-size: 0.75rem; margin-left: 0.5rem;">
                            <i class="fas fa-eye"></i>
                        </a>
                    </div>
                </div>
            </div>
            <div class="card-body" style="padding: 0;">
                <table style="margin: 0;">
                    <tbody>
                        @foreach($voucher->entries as $entry)
                        <tr>
                            <td style="padding-left: {{ $entry->credit > 0 ? '2rem' : '1rem' }};">
                                @if($entry->debit > 0)
                                    {{ $entry->account->name }} <strong>Dr.</strong>
                                @else
                                    &nbsp;&nbsp;&nbsp;&nbsp;To: {{ $entry->account->name }}
                                @endif
                            </td>
                            <td class="text-right" style="width: 120px;">
                                {{ $entry->debit > 0 ? number_format($entry->debit, 2) : '-' }}
                            </td>
                            <td class="text-right" style="width: 120px;">
                                {{ $entry->credit > 0 ? number_format($entry->credit, 2) : '-' }}
                            </td>
                        </tr>
                        @endforeach
                        @if($voucher->narration)
                        <tr>
                            <td colspan="3" style="font-style: italic; color: var(--secondary-color);">
                                Narration: {{ $voucher->narration }}
                            </td>
                        </tr>
                        @endif
                    </tbody>
                </table>
            </div>
        </div>
        @empty
        <div class="alert alert-warning">
            <i class="fas fa-info-circle"></i> No vouchers found for the selected period.
        </div>
        @endforelse
    </div>
</div>
@endsection
