@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-exchange-alt"></i> Cash Flow Statement</h3>
        <button class="btn btn-outline" onclick="window.print()">
            <i class="fas fa-print"></i> Print
        </button>
    </div>
    <div class="card-body">
        <!-- Filter -->
        <form method="GET" action="{{ route('reports.cash-flow') }}" class="mb-4">
            <div class="form-row">
                <div class="form-group" style="flex: 0 0 150px;">
                    <label class="form-label">From Date</label>
                    <input type="date" name="from_date" class="form-control" value="{{ $fromDate }}">
                </div>
                <div class="form-group" style="flex: 0 0 150px;">
                    <label class="form-label">To Date</label>
                    <input type="date" name="to_date" class="form-control" value="{{ $toDate }}">
                </div>
                <div class="form-group" style="flex: 0 0 auto; display: flex; align-items: flex-end;">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-search"></i> Generate
                    </button>
                </div>
            </div>
        </form>

        <div class="alert alert-info">
            <strong>Period:</strong> {{ \Carbon\Carbon::parse($fromDate)->format('d M Y') }} to {{ \Carbon\Carbon::parse($toDate)->format('d M Y') }}
        </div>

        <div style="display: flex; gap: 2rem;">
            <!-- Cash Inflows -->
            <div style="flex: 1;">
                <h4 style="background: var(--success-color); color: #fff; padding: 0.75rem; margin: 0;">
                    <i class="fas fa-arrow-down"></i> Cash Inflows (Receipts)
                </h4>
                <table style="border: 1px solid var(--border-color);">
                    <tbody>
                        @forelse($inflows as $inflow)
                        <tr>
                            <td>{{ $inflow->account->name ?? 'Unknown' }}</td>
                            <td class="text-right" style="width: 130px;">{{ number_format($inflow->amount, 2) }}</td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="2" class="text-center">No inflows recorded</td>
                        </tr>
                        @endforelse
                    </tbody>
                    <tfoot>
                        <tr style="background: var(--light-bg); font-weight: 700;">
                            <td>Total Inflows</td>
                            <td class="text-right text-success">Rs. {{ number_format($totalInflow, 2) }}</td>
                        </tr>
                    </tfoot>
                </table>
            </div>

            <!-- Cash Outflows -->
            <div style="flex: 1;">
                <h4 style="background: var(--danger-color); color: #fff; padding: 0.75rem; margin: 0;">
                    <i class="fas fa-arrow-up"></i> Cash Outflows (Payments)
                </h4>
                <table style="border: 1px solid var(--border-color);">
                    <tbody>
                        @forelse($outflows as $outflow)
                        <tr>
                            <td>{{ $outflow->account->name ?? 'Unknown' }}</td>
                            <td class="text-right" style="width: 130px;">{{ number_format($outflow->amount, 2) }}</td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="2" class="text-center">No outflows recorded</td>
                        </tr>
                        @endforelse
                    </tbody>
                    <tfoot>
                        <tr style="background: var(--light-bg); font-weight: 700;">
                            <td>Total Outflows</td>
                            <td class="text-right text-danger">Rs. {{ number_format($totalOutflow, 2) }}</td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>

        <!-- Net Cash Flow -->
        @php $netCashFlow = $totalInflow - $totalOutflow; @endphp
        <div class="card mt-4" style="background: {{ $netCashFlow >= 0 ? 'var(--success-color)' : 'var(--danger-color)' }}; color: #fff; padding: 1.5rem; text-align: center;">
            <div style="font-size: 1rem;">Net Cash Flow</div>
            <div style="font-size: 2rem; font-weight: 700;">
                Rs. {{ number_format(abs($netCashFlow), 2) }}
                {{ $netCashFlow >= 0 ? '(Positive)' : '(Negative)' }}
            </div>
        </div>
    </div>
</div>
@endsection
