@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-book"></i> Cash Book</h3>
        <button class="btn btn-outline" onclick="window.print()">
            <i class="fas fa-print"></i> Print
        </button>
    </div>
    <div class="card-body">
        <!-- Filters -->
        <form method="GET" action="{{ route('reports.cash-book') }}" class="mb-4">
            <div class="form-row">
                <div class="form-group" style="flex: 0 0 150px;">
                    <label class="form-label">From Date</label>
                    <input type="date" name="from_date" class="form-control" value="{{ $fromDate }}">
                </div>
                <div class="form-group" style="flex: 0 0 150px;">
                    <label class="form-label">To Date</label>
                    <input type="date" name="to_date" class="form-control" value="{{ $toDate }}">
                </div>
                <div class="form-group" style="flex: 0 0 auto; display: flex; align-items: flex-end;">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-search"></i> View
                    </button>
                </div>
            </div>
        </form>

        @if($cashAccount)
        <div class="alert alert-info">
            <strong>{{ $cashAccount->name }}</strong> | 
            Period: {{ \Carbon\Carbon::parse($fromDate)->format('d-M-Y') }} to {{ \Carbon\Carbon::parse($toDate)->format('d-M-Y') }}
        </div>

        <table>
            <thead>
                <tr>
                    <th style="width: 100px;">Date</th>
                    <th>Particulars</th>
                    <th class="text-right" style="width: 130px;">Receipt (Dr)</th>
                    <th class="text-right" style="width: 130px;">Payment (Cr)</th>
                    <th class="text-right" style="width: 130px;">Balance</th>
                </tr>
            </thead>
            <tbody>
                <tr style="background: var(--light-bg); font-weight: 600;">
                    <td>{{ \Carbon\Carbon::parse($fromDate)->format('d-M-Y') }}</td>
                    <td>Opening Balance</td>
                    <td class="text-right">-</td>
                    <td class="text-right">-</td>
                    <td class="text-right text-success">{{ number_format($openingBalance, 2) }}</td>
                </tr>

                @php $balance = $openingBalance; @endphp
                @forelse($entries as $entry)
                @php $balance += $entry->debit - $entry->credit; @endphp
                <tr>
                    <td>{{ $entry->date->format('d-M-Y') }}</td>
                    <td>
                        @if($entry->transactionable)
                            @php $ref = $entry->transactionable; @endphp
                            @if($ref instanceof \App\Models\Purchase)
                                Purchase: {{ $ref->bill_no }}
                            @elseif($ref instanceof \App\Models\Sale)
                                Sale: {{ $ref->bill_no }}
                            @elseif($ref instanceof \App\Models\Voucher)
                                {{ $ref->type }}: {{ $ref->voucher_no }}
                            @else
                                {{ class_basename($ref) }}
                            @endif
                        @else
                            Transaction
                        @endif
                    </td>
                    <td class="text-right text-success">{{ $entry->debit > 0 ? number_format($entry->debit, 2) : '-' }}</td>
                    <td class="text-right text-danger">{{ $entry->credit > 0 ? number_format($entry->credit, 2) : '-' }}</td>
                    <td class="text-right">{{ number_format($balance, 2) }}</td>
                </tr>
                @empty
                <tr>
                    <td colspan="5" class="text-center">No transactions found</td>
                </tr>
                @endforelse
            </tbody>
            <tfoot>
                <tr style="background: var(--light-bg); font-weight: 700;">
                    <td colspan="2" class="text-right">Total:</td>
                    <td class="text-right text-success">{{ number_format($entries->sum('debit'), 2) }}</td>
                    <td class="text-right text-danger">{{ number_format($entries->sum('credit'), 2) }}</td>
                    <td class="text-right">{{ number_format($closingBalance, 2) }}</td>
                </tr>
            </tfoot>
        </table>
        @else
        <div class="alert alert-warning">
            <i class="fas fa-exclamation-triangle"></i> Cash account not found. Please create a "Cash in Hand" account.
        </div>
        @endif
    </div>
</div>
@endsection
