@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-shopping-cart"></i> Bill Wise Purchase Report</h3>
        <button class="btn btn-outline" onclick="window.print()">
            <i class="fas fa-print"></i> Print
        </button>
    </div>
    <div class="card-body">
        <!-- Filters -->
        <form method="GET" action="{{ route('reports.bill-wise-purchase') }}" class="mb-4">
            <div class="form-row">
                <div class="form-group" style="flex: 0 0 150px;">
                    <label class="form-label">From Date</label>
                    <input type="date" name="from_date" class="form-control" value="{{ $fromDate }}">
                </div>
                <div class="form-group" style="flex: 0 0 150px;">
                    <label class="form-label">To Date</label>
                    <input type="date" name="to_date" class="form-control" value="{{ $toDate }}">
                </div>
                <div class="form-group" style="flex: 1;">
                    <label class="form-label">Supplier</label>
                    <select name="party_id" class="form-control">
                        <option value="">All Suppliers</option>
                        @foreach($parties as $party)
                        <option value="{{ $party->id }}" {{ $partyId == $party->id ? 'selected' : '' }}>
                            {{ $party->name }}
                        </option>
                        @endforeach
                    </select>
                </div>
                <div class="form-group" style="flex: 0 0 auto; display: flex; align-items: flex-end;">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-search"></i> View
                    </button>
                </div>
            </div>
        </form>

        <!-- Summary Cards -->
        <div class="form-row mb-4">
            <div class="form-group" style="flex: 1;">
                <div class="card" style="background: var(--primary-color); color: #fff; padding: 1rem; text-align: center;">
                    <div style="font-size: 0.875rem;">Total Bills</div>
                    <div style="font-size: 1.5rem; font-weight: 700;">{{ $summary['count'] }}</div>
                </div>
            </div>
            <div class="form-group" style="flex: 1;">
                <div class="card" style="background: var(--warning-color); color: #000; padding: 1rem; text-align: center;">
                    <div style="font-size: 0.875rem;">Total Amount</div>
                    <div style="font-size: 1.5rem; font-weight: 700;">Rs. {{ number_format($summary['total_amount'], 2) }}</div>
                </div>
            </div>
            <div class="form-group" style="flex: 1;">
                <div class="card" style="background: var(--success-color); color: #fff; padding: 1rem; text-align: center;">
                    <div style="font-size: 0.875rem;">Total Paid</div>
                    <div style="font-size: 1.5rem; font-weight: 700;">Rs. {{ number_format($summary['total_paid'], 2) }}</div>
                </div>
            </div>
            <div class="form-group" style="flex: 1;">
                <div class="card" style="background: var(--danger-color); color: #fff; padding: 1rem; text-align: center;">
                    <div style="font-size: 0.875rem;">Total Due</div>
                    <div style="font-size: 1.5rem; font-weight: 700;">Rs. {{ number_format($summary['total_due'], 2) }}</div>
                </div>
            </div>
        </div>

        <!-- Purchases Table -->
        <table>
            <thead>
                <tr>
                    <th style="width: 100px;">Bill No</th>
                    <th style="width: 100px;">Date</th>
                    <th>Supplier</th>
                    <th style="width: 80px;">Items</th>
                    <th class="text-right" style="width: 120px;">Amount</th>
                    <th class="text-right" style="width: 100px;">Paid</th>
                    <th class="text-right" style="width: 100px;">Due</th>
                    <th style="width: 80px;">Status</th>
                </tr>
            </thead>
            <tbody>
                @forelse($purchases as $purchase)
                <tr>
                    <td>
                        <a href="{{ route('purchases.show', $purchase) }}">{{ $purchase->bill_no }}</a>
                    </td>
                    <td>{{ $purchase->date->format('d-M-Y') }}</td>
                    <td>{{ $purchase->party->name ?? 'N/A' }}</td>
                    <td class="text-center">{{ $purchase->items->count() }}</td>
                    <td class="text-right">{{ number_format($purchase->total_amount, 2) }}</td>
                    <td class="text-right text-success">{{ number_format($purchase->paid_amount, 2) }}</td>
                    <td class="text-right text-danger">{{ number_format($purchase->due_amount, 2) }}</td>
                    <td>
                        @if($purchase->due_amount <= 0)
                            <span class="badge badge-success">Paid</span>
                        @elseif($purchase->paid_amount > 0)
                            <span class="badge badge-warning">Partial</span>
                        @else
                            <span class="badge badge-danger">Unpaid</span>
                        @endif
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="8" class="text-center">No purchases found</td>
                </tr>
                @endforelse
            </tbody>
            <tfoot>
                <tr style="background: var(--light-bg); font-weight: 700;">
                    <td colspan="4" class="text-right">Total:</td>
                    <td class="text-right">{{ number_format($summary['total_amount'], 2) }}</td>
                    <td class="text-right text-success">{{ number_format($summary['total_paid'], 2) }}</td>
                    <td class="text-right text-danger">{{ number_format($summary['total_due'], 2) }}</td>
                    <td></td>
                </tr>
            </tfoot>
        </table>
    </div>
</div>
@endsection
