<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Purchase Bill - {{ $purchase->bill_no }}</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            font-size: 12px;
            line-height: 1.4;
            color: #333;
            background: #fff;
        }
        
        .bill-container {
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
        }
        
        /* Header */
        .bill-header {
            text-align: center;
            padding-bottom: 15px;
            border-bottom: 2px solid #333;
            margin-bottom: 15px;
        }
        
        .company-name {
            font-size: 24px;
            font-weight: bold;
            color: #1a5276;
            margin-bottom: 5px;
        }
        
        .company-tagline {
            font-size: 14px;
            color: #666;
            margin-bottom: 5px;
        }
        
        .company-address {
            font-size: 11px;
            color: #666;
        }
        
        .bill-title {
            font-size: 18px;
            font-weight: bold;
            margin-top: 10px;
            padding: 5px 20px;
            background: #1a5276;
            color: #fff;
            display: inline-block;
        }
        
        /* Bill Info */
        .bill-info {
            display: flex;
            justify-content: space-between;
            margin-bottom: 15px;
            padding: 10px;
            background: #f8f9fa;
            border: 1px solid #ddd;
        }
        
        .bill-info-left, .bill-info-right {
            width: 48%;
        }
        
        .info-row {
            display: flex;
            margin-bottom: 5px;
        }
        
        .info-label {
            font-weight: bold;
            width: 100px;
            color: #555;
        }
        
        .info-value {
            flex: 1;
        }
        
        /* Party Info */
        .party-info {
            margin-bottom: 15px;
            padding: 10px;
            border: 1px solid #ddd;
        }
        
        .party-info h4 {
            font-size: 12px;
            color: #666;
            margin-bottom: 5px;
            text-transform: uppercase;
        }
        
        .party-name {
            font-size: 16px;
            font-weight: bold;
            color: #333;
        }
        
        .party-details {
            font-size: 11px;
            color: #666;
            margin-top: 5px;
        }
        
        /* Items Table */
        .items-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 15px;
        }
        
        .items-table th {
            background: #1a5276;
            color: #fff;
            padding: 8px 10px;
            text-align: left;
            font-size: 11px;
            text-transform: uppercase;
        }
        
        .items-table th.text-right {
            text-align: right;
        }
        
        .items-table th.text-center {
            text-align: center;
        }
        
        .items-table td {
            padding: 8px 10px;
            border-bottom: 1px solid #ddd;
        }
        
        .items-table td.text-right {
            text-align: right;
        }
        
        .items-table td.text-center {
            text-align: center;
        }
        
        .items-table tbody tr:nth-child(even) {
            background: #f8f9fa;
        }
        
        .items-table tfoot td {
            padding: 10px;
            background: #f1f1f1;
            font-weight: bold;
        }
        
        /* Summary */
        .bill-summary {
            display: flex;
            justify-content: flex-end;
            margin-bottom: 15px;
        }
        
        .summary-table {
            width: 300px;
            border: 1px solid #ddd;
        }
        
        .summary-table tr td {
            padding: 8px 12px;
            border-bottom: 1px solid #ddd;
        }
        
        .summary-table tr td:first-child {
            text-align: right;
            color: #555;
        }
        
        .summary-table tr td:last-child {
            text-align: right;
            font-weight: bold;
            width: 120px;
        }
        
        .summary-table tr.total-row {
            background: #1a5276;
            color: #fff;
        }
        
        .summary-table tr.total-row td {
            font-size: 14px;
            padding: 12px;
            border: none;
        }
        
        /* Remarks */
        .remarks {
            padding: 10px;
            background: #f8f9fa;
            border: 1px solid #ddd;
            margin-bottom: 15px;
            font-size: 11px;
        }
        
        .remarks h4 {
            font-size: 11px;
            color: #666;
            margin-bottom: 5px;
        }
        
        /* Footer */
        .bill-footer {
            display: flex;
            justify-content: space-between;
            margin-top: 40px;
            padding-top: 15px;
            border-top: 1px dashed #ccc;
        }
        
        .signature-box {
            text-align: center;
            width: 200px;
        }
        
        .signature-line {
            border-top: 1px solid #333;
            margin-bottom: 5px;
            padding-top: 5px;
        }
        
        .signature-label {
            font-size: 11px;
            color: #666;
        }
        
        /* Print specific */
        @media print {
            body {
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }
            
            .bill-container {
                padding: 0;
            }
            
            .no-print {
                display: none !important;
            }
        }
        
        /* Action buttons */
        .action-buttons {
            text-align: center;
            margin-bottom: 20px;
            padding: 15px;
            background: #f1f1f1;
            border-radius: 5px;
        }
        
        .action-buttons button, .action-buttons a {
            padding: 10px 20px;
            margin: 0 5px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
            font-size: 14px;
        }
        
        .btn-print {
            background: #1a5276;
            color: #fff;
        }
        
        .btn-back {
            background: #6c757d;
            color: #fff;
        }
        
        .btn-print:hover {
            background: #154360;
        }
        
        .btn-back:hover {
            background: #5a6268;
        }
    </style>
</head>
<body>
    <div class="bill-container">
        <!-- Action Buttons (hidden in print) -->
        <div class="action-buttons no-print">
            <button class="btn-print" onclick="window.print()">
                🖨️ Print Bill
            </button>
            <a href="{{ route('purchases.show', $purchase) }}" class="btn-back">
                ← Back to Bill
            </a>
        </div>
        
        <!-- Bill Header -->
        <div class="bill-header">
            <div class="company-name">USMAN BILAL ENTERPRISES</div>
            <div class="company-tagline">Cotton Waste Processor & Dealer</div>
            <div class="company-address">
                Address: Your Business Address Here | Phone: 000-0000000 | Email: info@usmanbilanent.com
            </div>
            <div class="bill-title">PURCHASE BILL</div>
        </div>
        
        <!-- Bill Info -->
        <div class="bill-info">
            <div class="bill-info-left">
                <div class="info-row">
                    <span class="info-label">Bill No:</span>
                    <span class="info-value"><strong>{{ $purchase->bill_no }}</strong></span>
                </div>
                <div class="info-row">
                    <span class="info-label">Date:</span>
                    <span class="info-value">{{ $purchase->date->format('d-M-Y') }}</span>
                </div>
                @if($purchase->ref_no)
                <div class="info-row">
                    <span class="info-label">Reference:</span>
                    <span class="info-value">{{ $purchase->ref_no }}</span>
                </div>
                @endif
            </div>
            <div class="bill-info-right">
                <div class="info-row">
                    <span class="info-label">Created:</span>
                    <span class="info-value">{{ $purchase->created_at->format('d-M-Y h:i A') }}</span>
                </div>
                <div class="info-row">
                    <span class="info-label">User:</span>
                    <span class="info-value">{{ $purchase->user->name ?? 'System' }}</span>
                </div>
            </div>
        </div>
        
        <!-- Party Info -->
        <div class="party-info">
            <h4>Supplier Details</h4>
            <div class="party-name">{{ $purchase->party->name }}</div>
            <div class="party-details">
                Code: {{ $purchase->party->code }}
                @if($purchase->party->phone) | Phone: {{ $purchase->party->phone }} @endif
                @if($purchase->party->address) <br>Address: {{ $purchase->party->address }} @endif
            </div>
        </div>
        
        <!-- Items Table -->
        <table class="items-table">
            <thead>
                <tr>
                    <th class="text-center" style="width: 40px;">#</th>
                    <th>Item Description</th>
                    <th style="width: 80px;">Code</th>
                    <th class="text-right" style="width: 80px;">Qty</th>
                    <th class="text-center" style="width: 60px;">Unit</th>
                    <th class="text-right" style="width: 100px;">Rate</th>
                    <th class="text-right" style="width: 120px;">Amount</th>
                </tr>
            </thead>
            <tbody>
                @foreach($purchase->items as $index => $item)
                <tr>
                    <td class="text-center">{{ $index + 1 }}</td>
                    <td>{{ $item->item->name }}</td>
                    <td>{{ $item->item->code }}</td>
                    <td class="text-right">{{ number_format($item->quantity, 2) }}</td>
                    <td class="text-center">{{ $item->item->unit }}</td>
                    <td class="text-right">{{ number_format($item->rate, 2) }}</td>
                    <td class="text-right">{{ number_format($item->amount, 2) }}</td>
                </tr>
                @endforeach
            </tbody>
            <tfoot>
                <tr>
                    <td colspan="3" class="text-right">Total Items: {{ $purchase->items->count() }}</td>
                    <td class="text-right">{{ number_format($purchase->items->sum('quantity'), 2) }}</td>
                    <td colspan="2"></td>
                    <td class="text-right">Rs. {{ number_format($purchase->gross_amount, 2) }}</td>
                </tr>
            </tfoot>
        </table>
        
        <!-- Summary -->
        <div class="bill-summary">
            <table class="summary-table">
                <tr>
                    <td>Gross Amount:</td>
                    <td>Rs. {{ number_format($purchase->gross_amount, 2) }}</td>
                </tr>
                <tr>
                    <td>Discount:</td>
                    <td>Rs. {{ number_format($purchase->discount, 2) }}</td>
                </tr>
                <tr class="total-row">
                    <td>Net Amount:</td>
                    <td>Rs. {{ number_format($purchase->net_amount, 2) }}</td>
                </tr>
            </table>
        </div>
        
        <!-- Remarks -->
        @if($purchase->remarks)
        <div class="remarks">
            <h4>Remarks:</h4>
            {{ $purchase->remarks }}
        </div>
        @endif
        
        <!-- Amount in Words -->
        <div class="remarks">
            <h4>Amount in Words:</h4>
            <strong>{{ $amountInWords ?? 'Rupees ' . number_format($purchase->net_amount, 2) . ' Only' }}</strong>
        </div>
        
        <!-- Footer Signatures -->
        <div class="bill-footer">
            <div class="signature-box">
                <div class="signature-line">Received By</div>
                <div class="signature-label">Signature & Stamp</div>
            </div>
            <div class="signature-box">
                <div class="signature-line">Checked By</div>
                <div class="signature-label">Authorized Signature</div>
            </div>
            <div class="signature-box">
                <div class="signature-line">Approved By</div>
                <div class="signature-label">Management</div>
            </div>
        </div>
    </div>
</body>
</html>
