@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-shopping-cart"></i> Purchase Register</h3>
        <a href="{{ route('purchases.create') }}" class="btn btn-primary">
            <i class="fas fa-plus"></i> New Purchase Bill
        </a>
    </div>
    <div class="card-body">
        @if(session('success'))
            <div class="alert" style="background-color: #d4edda; border: 1px solid #c3e6cb; color: #155724; padding: 1rem; border-radius: 4px; margin-bottom: 1rem;">
                <i class="fas fa-check-circle"></i> {{ session('success') }}
            </div>
        @endif
        @if(session('error'))
            <div class="alert" style="background-color: #f8d7da; border: 1px solid #f5c6cb; color: #721c24; padding: 1rem; border-radius: 4px; margin-bottom: 1rem;">
                <i class="fas fa-exclamation-circle"></i> {{ session('error') }}
            </div>
        @endif

        <!-- Filters -->
        <form method="GET" action="{{ route('purchases.index') }}">
            <div class="form-row mb-4">
                <div class="form-group" style="flex: 0 0 150px;">
                    <label class="form-label">From Date</label>
                    <input type="date" class="form-control" name="from_date" value="{{ request('from_date', date('Y-m-01')) }}">
                </div>
                <div class="form-group" style="flex: 0 0 150px;">
                    <label class="form-label">To Date</label>
                    <input type="date" class="form-control" name="to_date" value="{{ request('to_date', date('Y-m-d')) }}">
                </div>
                <div class="form-group" style="flex: 1;">
                    <label class="form-label">Supplier</label>
                    <select class="form-control" name="party_id">
                        <option value="">All Suppliers</option>
                        @foreach($parties as $party)
                            <option value="{{ $party->id }}" {{ request('party_id') == $party->id ? 'selected' : '' }}>
                                {{ $party->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="form-group" style="flex: 0 0 200px;">
                    <label class="form-label">Search</label>
                    <input type="text" class="form-control" name="search" value="{{ request('search') }}" placeholder="Bill No...">
                </div>
                <div class="form-group" style="flex: 0 0 auto; display: flex; align-items: flex-end;">
                    <button type="submit" class="btn btn-primary" style="margin-right: 0.5rem;">
                        <i class="fas fa-search"></i> Search
                    </button>
                    <a href="{{ route('purchases.index') }}" class="btn btn-outline"><i class="fas fa-times"></i></a>
                </div>
            </div>
        </form>

        <div class="table-responsive">
            <table>
                <thead>
                    <tr>
                        <th>Bill No.</th>
                        <th>Date</th>
                        <th>Supplier</th>
                        <th>Ref. No.</th>
                        <th class="text-right">Gross Amt</th>
                        <th class="text-right">Discount</th>
                        <th class="text-right">Net Amount</th>
                        <th class="text-right">Balance</th>
                        <th class="text-center">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($purchases as $purchase)
                        <tr>
                            <td><strong>{{ $purchase->bill_no }}</strong></td>
                            <td>{{ \Carbon\Carbon::parse($purchase->date)->format('d M Y') }}</td>
                            <td>{{ $purchase->party->name ?? '-' }}</td>
                            <td>{{ $purchase->ref_no ?: '-' }}</td>
                            <td class="text-right">Rs. {{ number_format($purchase->gross_amount, 2) }}</td>
                            <td class="text-right">Rs. {{ number_format($purchase->discount_amount, 2) }}</td>
                            <td class="text-right" style="font-weight: 600;">Rs. {{ number_format($purchase->net_amount, 2) }}</td>
                            <td class="text-right" style="{{ $purchase->balance_amount > 0 ? 'color: #dc3545;' : 'color: #28a745;' }}">
                                Rs. {{ number_format($purchase->balance_amount, 2) }}
                            </td>
                            <td class="text-center">
                                <a href="{{ route('purchases.show', $purchase) }}" class="btn btn-outline" style="padding: 0.25rem 0.5rem;" title="View">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="{{ route('purchases.print', $purchase) }}" class="btn btn-outline" style="padding: 0.25rem 0.5rem;" title="Print" target="_blank">
                                    <i class="fas fa-print"></i>
                                </a>
                                <a href="{{ route('purchases.edit', $purchase) }}" class="btn btn-outline" style="padding: 0.25rem 0.5rem;" title="Edit">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <form action="{{ route('purchases.destroy', $purchase) }}" method="POST" style="display: inline;">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-outline" style="padding: 0.25rem 0.5rem; color: var(--danger-color);" onclick="return confirm('Are you sure you want to delete this purchase bill?')" title="Delete">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="9" class="text-center text-muted" style="padding: 3rem;">
                                <i class="fas fa-file-invoice" style="font-size: 3rem; display: block; margin-bottom: 1rem; opacity: 0.5;"></i>
                                <p style="margin: 0;">No purchase bills found. <a href="{{ route('purchases.create') }}">Create your first purchase</a></p>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <!-- Summary -->
        <div style="display: flex; justify-content: flex-end; margin-top: 1rem; padding-top: 1rem; border-top: 1px solid var(--border-color);">
            <table style="width: 350px; border: none;">
                <tr>
                    <td style="padding: 0.5rem; border: none;">Total Bills:</td>
                    <td style="padding: 0.5rem; border: none; text-align: right;"><strong>{{ $purchases->count() }}</strong></td>
                </tr>
                <tr>
                    <td style="padding: 0.5rem; border: none;">Total Gross Amount:</td>
                    <td style="padding: 0.5rem; border: none; text-align: right;">Rs. {{ number_format($purchases->sum('gross_amount'), 2) }}</td>
                </tr>
                <tr>
                    <td style="padding: 0.5rem; border: none;">Total Discount:</td>
                    <td style="padding: 0.5rem; border: none; text-align: right;">Rs. {{ number_format($purchases->sum('discount_amount'), 2) }}</td>
                </tr>
                <tr>
                    <td style="padding: 0.5rem; border: none; font-weight: 600;">Total Net Amount:</td>
                    <td style="padding: 0.5rem; border: none; text-align: right;"><strong style="color: var(--primary-color);">Rs. {{ number_format($purchases->sum('net_amount'), 2) }}</strong></td>
                </tr>
                <tr>
                    <td style="padding: 0.5rem; border: none;">Total Balance:</td>
                    <td style="padding: 0.5rem; border: none; text-align: right; color: #dc3545;"><strong>Rs. {{ number_format($purchases->sum('balance_amount'), 2) }}</strong></td>
                </tr>
            </table>
        </div>
    </div>
</div>
@endsection
