@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-user-circle"></i> My Profile</h3>
    </div>
    <div class="card-body">
        <form action="{{ route('profile.update') }}" method="POST">
            @csrf
            @method('PATCH')
            
            <div class="form-row">
                <div class="form-group">
                    <label class="form-label" for="name">Full Name</label>
                    <input type="text" class="form-control @error('name') is-invalid @enderror" 
                           id="name" name="name" value="{{ old('name', $user->name) }}" required>
                    @error('name')
                        <span class="error-message">{{ $message }}</span>
                    @enderror
                </div>

                <div class="form-group">
                    <label class="form-label" for="email">Email Address</label>
                    <input type="email" class="form-control @error('email') is-invalid @enderror" 
                           id="email" name="email" value="{{ old('email', $user->email) }}" required>
                    @error('email')
                        <span class="error-message">{{ $message }}</span>
                    @enderror
                </div>
            </div>

            <hr style="margin: 1.5rem 0;">

            <h4 style="font-size: 1rem; margin-bottom: 1rem;">Change Password</h4>
            <p class="text-muted" style="font-size: 0.875rem; margin-bottom: 1rem;">
                Leave blank if you don't want to change your password
            </p>

            <div class="form-row">
                <div class="form-group">
                    <label class="form-label" for="current_password">Current Password</label>
                    <input type="password" class="form-control @error('current_password') is-invalid @enderror" 
                           id="current_password" name="current_password">
                    @error('current_password')
                        <span class="error-message">{{ $message }}</span>
                    @enderror
                </div>

                <div class="form-group">
                    <label class="form-label" for="password">New Password</label>
                    <input type="password" class="form-control @error('password') is-invalid @enderror" 
                           id="password" name="password">
                    @error('password')
                        <span class="error-message">{{ $message }}</span>
                    @enderror
                </div>

                <div class="form-group">
                    <label class="form-label" for="password_confirmation">Confirm New Password</label>
                    <input type="password" class="form-control" 
                           id="password_confirmation" name="password_confirmation">
                </div>
            </div>

            <div style="display: flex; gap: 0.5rem; margin-top: 1.5rem;">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> Update Profile
                </button>
            </div>
        </form>
    </div>
</div>

<div class="card mt-4">
    <div class="card-header">
        <h3 class="card-title text-danger"><i class="fas fa-exclamation-triangle"></i> Delete Account</h3>
    </div>
    <div class="card-body">
        <p class="text-muted">
            Once your account is deleted, all of its resources and data will be permanently deleted. 
            Please enter your password to confirm you would like to permanently delete your account.
        </p>
        
        <form action="{{ route('profile.destroy') }}" method="POST" 
              onsubmit="return confirm('Are you sure you want to delete your account? This action cannot be undone.');">
            @csrf
            @method('DELETE')
            
            <div class="form-group" style="max-width: 300px;">
                <label class="form-label" for="delete_password">Password</label>
                <input type="password" class="form-control" id="delete_password" name="password" required>
            </div>

            <button type="submit" class="btn btn-danger">
                <i class="fas fa-trash"></i> Delete Account
            </button>
        </form>
    </div>
</div>
@endsection
