@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-eye"></i> Party Details: {{ $party->name }}</h3>
        <div>
            <a href="{{ route('parties.edit', $party) }}" class="btn btn-primary" style="margin-right: 0.5rem;">
                <i class="fas fa-edit"></i> Edit
            </a>
            <a href="{{ route('parties.index') }}" class="btn btn-outline">
                <i class="fas fa-arrow-left"></i> Back
            </a>
        </div>
    </div>
    <div class="card-body">
        <!-- Party Info Cards -->
        <div class="form-row mb-4">
            <div class="form-group" style="flex: 1;">
                <div style="background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%); padding: 1.5rem; border-radius: 8px; height: 100%;">
                    <div style="font-size: 0.85rem; color: #6c757d; margin-bottom: 0.5rem;">Party Code</div>
                    <div style="font-size: 1.5rem; font-weight: 700; color: var(--primary-color);">{{ $party->code }}</div>
                </div>
            </div>
            <div class="form-group" style="flex: 2;">
                <div style="background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%); padding: 1.5rem; border-radius: 8px; height: 100%;">
                    <div style="font-size: 0.85rem; color: #6c757d; margin-bottom: 0.5rem;">Party Name</div>
                    <div style="font-size: 1.5rem; font-weight: 700;">{{ $party->name }}</div>
                </div>
            </div>
            <div class="form-group" style="flex: 1;">
                <div style="background: linear-gradient(135deg, #d4edda 0%, #c3e6cb 100%); padding: 1.5rem; border-radius: 8px; height: 100%;">
                    <div style="font-size: 0.85rem; color: #155724; margin-bottom: 0.5rem;">Current Balance</div>
                    <div style="font-size: 1.5rem; font-weight: 700; color: #155724;">Rs. {{ number_format($party->current_balance, 2) }}</div>
                </div>
            </div>
        </div>

        <!-- Party Details -->
        <div class="form-row">
            <div class="form-group" style="flex: 1;">
                <div style="border: 1px solid #dee2e6; border-radius: 8px; padding: 1rem;">
                    <h4 style="margin: 0 0 1rem 0; padding-bottom: 0.5rem; border-bottom: 1px solid #dee2e6;">
                        <i class="fas fa-info-circle"></i> Basic Information
                    </h4>
                    <table style="width: 100%;">
                        <tr>
                            <td style="padding: 0.5rem 0; color: #6c757d; width: 40%;">Type:</td>
                            <td style="padding: 0.5rem 0; font-weight: 500;">
                                @php
                                    $typeLabels = ['customer' => 'Customer', 'supplier' => 'Supplier', 'both' => 'Customer & Supplier'];
                                    $typeColors = ['customer' => '#28a745', 'supplier' => '#007bff', 'both' => '#6f42c1'];
                                @endphp
                                <span style="background-color: {{ $typeColors[$party->type] ?? '#6c757d' }}; color: white; padding: 0.25rem 0.5rem; border-radius: 4px; font-size: 0.85rem;">
                                    {{ $typeLabels[$party->type] ?? ucfirst($party->type) }}
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td style="padding: 0.5rem 0; color: #6c757d;">Phone:</td>
                            <td style="padding: 0.5rem 0;">{{ $party->phone ?: '-' }}</td>
                        </tr>
                        <tr>
                            <td style="padding: 0.5rem 0; color: #6c757d;">Mobile:</td>
                            <td style="padding: 0.5rem 0;">{{ $party->mobile ?: '-' }}</td>
                        </tr>
                        <tr>
                            <td style="padding: 0.5rem 0; color: #6c757d;">Email:</td>
                            <td style="padding: 0.5rem 0;">{{ $party->email ?: '-' }}</td>
                        </tr>
                        <tr>
                            <td style="padding: 0.5rem 0; color: #6c757d;">City:</td>
                            <td style="padding: 0.5rem 0;">{{ $party->city ?: '-' }}</td>
                        </tr>
                        <tr>
                            <td style="padding: 0.5rem 0; color: #6c757d;">Address:</td>
                            <td style="padding: 0.5rem 0;">{{ $party->address ?: '-' }}</td>
                        </tr>
                        <tr>
                            <td style="padding: 0.5rem 0; color: #6c757d;">NTN:</td>
                            <td style="padding: 0.5rem 0;">{{ $party->ntn ?: '-' }}</td>
                        </tr>
                        <tr>
                            <td style="padding: 0.5rem 0; color: #6c757d;">CNIC:</td>
                            <td style="padding: 0.5rem 0;">{{ $party->cnic ?: '-' }}</td>
                        </tr>
                        <tr>
                            <td style="padding: 0.5rem 0; color: #6c757d;">Status:</td>
                            <td style="padding: 0.5rem 0;">
                                @if($party->is_active)
                                    <span style="background-color: #28a745; color: white; padding: 0.2rem 0.5rem; border-radius: 4px; font-size: 0.8rem;">Active</span>
                                @else
                                    <span style="background-color: #6c757d; color: white; padding: 0.2rem 0.5rem; border-radius: 4px; font-size: 0.8rem;">Inactive</span>
                                @endif
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
            
            <div class="form-group" style="flex: 1;">
                <div style="border: 1px solid #dee2e6; border-radius: 8px; padding: 1rem;">
                    <h4 style="margin: 0 0 1rem 0; padding-bottom: 0.5rem; border-bottom: 1px solid #dee2e6;">
                        <i class="fas fa-money-bill-wave"></i> Financial Information
                    </h4>
                    <table style="width: 100%;">
                        <tr>
                            <td style="padding: 0.5rem 0; color: #6c757d; width: 40%;">Opening Balance:</td>
                            <td style="padding: 0.5rem 0;">
                                Rs. {{ number_format($party->opening_balance, 2) }}
                                <span style="font-size: 0.85rem; color: #6c757d;">({{ ucfirst($party->opening_type) }})</span>
                            </td>
                        </tr>
                        <tr>
                            <td style="padding: 0.5rem 0; color: #6c757d;">Current Balance:</td>
                            <td style="padding: 0.5rem 0; font-weight: 700; font-size: 1.1rem; color: var(--primary-color);">
                                Rs. {{ number_format($party->current_balance, 2) }}
                            </td>
                        </tr>
                        <tr>
                            <td style="padding: 0.5rem 0; color: #6c757d;">Credit Limit:</td>
                            <td style="padding: 0.5rem 0;">
                                {{ $party->credit_limit ? 'Rs. ' . number_format($party->credit_limit, 2) : 'No Limit' }}
                            </td>
                        </tr>
                        <tr>
                            <td style="padding: 0.5rem 0; color: #6c757d;">Credit Days:</td>
                            <td style="padding: 0.5rem 0;">{{ $party->credit_days ?: '0' }} days</td>
                        </tr>
                        <tr>
                            <td style="padding: 0.5rem 0; color: #6c757d;">Linked Account:</td>
                            <td style="padding: 0.5rem 0;">
                                @if($party->account)
                                    <a href="{{ route('accounts.show', $party->account) }}">{{ $party->account->code }} - {{ $party->account->name }}</a>
                                @else
                                    <span style="color: #6c757d;">Not linked</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <td style="padding: 0.5rem 0; color: #6c757d;">Created:</td>
                            <td style="padding: 0.5rem 0;">{{ $party->created_at->format('d M Y, h:i A') }}</td>
                        </tr>
                        <tr>
                            <td style="padding: 0.5rem 0; color: #6c757d;">Last Updated:</td>
                            <td style="padding: 0.5rem 0;">{{ $party->updated_at->format('d M Y, h:i A') }}</td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>

        <!-- Transaction Summary -->
        <div class="form-row" style="margin-top: 1.5rem;">
            <div class="form-group" style="flex: 1;">
                <div style="border: 1px solid #dee2e6; border-radius: 8px; padding: 1rem;">
                    <h4 style="margin: 0 0 1rem 0; padding-bottom: 0.5rem; border-bottom: 1px solid #dee2e6;">
                        <i class="fas fa-shopping-cart"></i> Purchase History
                    </h4>
                    @if($party->purchases && $party->purchases->count() > 0)
                        <table style="width: 100%;">
                            <thead>
                                <tr>
                                    <th style="padding: 0.5rem; text-align: left;">Bill No</th>
                                    <th style="padding: 0.5rem; text-align: left;">Date</th>
                                    <th style="padding: 0.5rem; text-align: right;">Amount</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($party->purchases->take(10) as $purchase)
                                    <tr>
                                        <td style="padding: 0.5rem;">
                                            <a href="{{ route('purchases.show', $purchase) }}">{{ $purchase->bill_no }}</a>
                                        </td>
                                        <td style="padding: 0.5rem;">{{ \Carbon\Carbon::parse($purchase->date)->format('d M Y') }}</td>
                                        <td style="padding: 0.5rem; text-align: right;">Rs. {{ number_format($purchase->net_amount, 2) }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                        @if($party->purchases->count() > 10)
                            <div style="margin-top: 0.5rem; text-align: center;">
                                <a href="{{ route('purchases.index', ['party_id' => $party->id]) }}" class="btn btn-outline btn-sm">View All Purchases</a>
                            </div>
                        @endif
                    @else
                        <p style="text-align: center; color: #6c757d; margin: 2rem 0;">No purchases found.</p>
                    @endif
                </div>
            </div>

            <div class="form-group" style="flex: 1;">
                <div style="border: 1px solid #dee2e6; border-radius: 8px; padding: 1rem;">
                    <h4 style="margin: 0 0 1rem 0; padding-bottom: 0.5rem; border-bottom: 1px solid #dee2e6;">
                        <i class="fas fa-shopping-bag"></i> Sales History
                    </h4>
                    @if($party->sales && $party->sales->count() > 0)
                        <table style="width: 100%;">
                            <thead>
                                <tr>
                                    <th style="padding: 0.5rem; text-align: left;">Bill No</th>
                                    <th style="padding: 0.5rem; text-align: left;">Date</th>
                                    <th style="padding: 0.5rem; text-align: right;">Amount</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($party->sales->take(10) as $sale)
                                    <tr>
                                        <td style="padding: 0.5rem;">
                                            <a href="{{ route('sales.show', $sale) }}">{{ $sale->bill_no }}</a>
                                        </td>
                                        <td style="padding: 0.5rem;">{{ \Carbon\Carbon::parse($sale->date)->format('d M Y') }}</td>
                                        <td style="padding: 0.5rem; text-align: right;">Rs. {{ number_format($sale->net_amount, 2) }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                        @if($party->sales->count() > 10)
                            <div style="margin-top: 0.5rem; text-align: center;">
                                <a href="{{ route('sales.index', ['party_id' => $party->id]) }}" class="btn btn-outline btn-sm">View All Sales</a>
                            </div>
                        @endif
                    @else
                        <p style="text-align: center; color: #6c757d; margin: 2rem 0;">No sales found.</p>
                    @endif
                </div>
            </div>
        </div>

        <!-- Contracts Section -->
        <div class="form-row mt-4">
            <div class="form-group" style="flex: 1;">
                <div style="border: 1px solid #dee2e6; border-radius: 8px; padding: 1rem;">
                    <h4 style="margin: 0 0 1rem 0; padding-bottom: 0.5rem; border-bottom: 1px solid #dee2e6; display: flex; justify-content: space-between; align-items: center;">
                        <span><i class="fas fa-file-contract"></i> Contracts</span>
                        <a href="{{ route('contracts.create', ['type' => $party->type == 'customer' ? 'sale' : 'purchase', 'party_id' => $party->id]) }}" class="btn btn-sm btn-primary">
                            <i class="fas fa-plus"></i> New Contract
                        </a>
                    </h4>
                    @if($party->contracts && $party->contracts->count() > 0)
                        <table style="width: 100%;">
                            <thead>
                                <tr style="background: #f8f9fa;">
                                    <th style="padding: 0.5rem; text-align: left;">Contract No</th>
                                    <th style="padding: 0.5rem; text-align: left;">Type</th>
                                    <th style="padding: 0.5rem; text-align: right;">Qty</th>
                                    <th style="padding: 0.5rem; text-align: right;">Pending</th>
                                    <th style="padding: 0.5rem; text-align: center;">Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($party->contracts->take(10) as $contract)
                                    <tr>
                                        <td style="padding: 0.5rem;">
                                            <a href="{{ route('contracts.show', $contract) }}">{{ $contract->contract_no }}</a>
                                        </td>
                                        <td style="padding: 0.5rem;">
                                            <span style="background: {{ $contract->type == 'purchase' ? '#e3f2fd' : '#e8f5e9' }}; color: {{ $contract->type == 'purchase' ? '#1565c0' : '#2e7d32' }}; padding: 2px 6px; border-radius: 4px; font-size: 11px;">
                                                {{ ucfirst($contract->type) }}
                                            </span>
                                        </td>
                                        <td style="padding: 0.5rem; text-align: right;">{{ number_format($contract->agreed_quantity, 2) }}</td>
                                        <td style="padding: 0.5rem; text-align: right; color: {{ $contract->pending_quantity > 0 ? '#c62828' : '#2e7d32' }};">
                                            {{ number_format($contract->pending_quantity, 2) }}
                                        </td>
                                        <td style="padding: 0.5rem; text-align: center;">
                                            @php
                                                $statusColors = [
                                                    'draft' => 'background: #fafafa; color: #666;',
                                                    'active' => 'background: #e8f5e9; color: #2e7d32;',
                                                    'completed' => 'background: #e3f2fd; color: #1565c0;',
                                                    'cancelled' => 'background: #ffebee; color: #c62828;',
                                                ];
                                            @endphp
                                            <span style="{{ $statusColors[$contract->status] ?? '' }} padding: 2px 6px; border-radius: 4px; font-size: 11px;">
                                                {{ ucfirst($contract->status) }}
                                            </span>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                        @if($party->contracts->count() > 10)
                            <div style="margin-top: 0.5rem; text-align: center;">
                                <a href="{{ route('contracts.index', ['party_id' => $party->id]) }}" class="btn btn-outline btn-sm">View All Contracts</a>
                            </div>
                        @endif
                    @else
                        <p style="text-align: center; color: #6c757d; margin: 2rem 0;">No contracts found for this party.</p>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
