@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-truck"></i> Purchase Parties (Suppliers)</h3>
        <a href="{{ route('parties.create') }}?type=supplier" class="btn btn-primary">
            <i class="fas fa-plus"></i> New Supplier
        </a>
    </div>
    <div class="card-body">
        <!-- Filters -->
        <div class="form-row mb-4">
            <div class="form-group" style="flex: 1;">
                <label class="form-label">Search</label>
                <input type="text" class="form-control" id="searchParty" placeholder="Search by name, code, phone...">
            </div>
            <div class="form-group" style="flex: 0 0 150px;">
                <label class="form-label">Balance Type</label>
                <select class="form-control" id="balanceType">
                    <option value="">All</option>
                    <option value="payable">Payable Only</option>
                    <option value="advance">Advance Only</option>
                    <option value="zero">Zero Balance</option>
                </select>
            </div>
            <div class="form-group" style="flex: 0 0 100px; display: flex; align-items: flex-end;">
                <button class="btn btn-primary" style="width: 100%;">
                    <i class="fas fa-search"></i> Search
                </button>
            </div>
        </div>

        <div class="table-responsive">
            <table>
                <thead>
                    <tr>
                        <th>Code</th>
                        <th>Supplier Name</th>
                        <th>Contact Person</th>
                        <th>Phone</th>
                        <th>City</th>
                        <th class="text-right">Balance</th>
                        <th class="text-center">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($parties ?? [] as $party)
                        <tr>
                            <td><strong>{{ $party->code }}</strong></td>
                            <td>{{ $party->name }}</td>
                            <td>{{ $party->contact_person ?? '-' }}</td>
                            <td>{{ $party->phone ?? '-' }}</td>
                            <td>{{ $party->city ?? '-' }}</td>
                            <td class="text-right">
                                @if(($party->balance ?? 0) > 0)
                                    <strong class="text-danger">Rs. {{ number_format($party->balance, 2) }} (Pay)</strong>
                                @elseif(($party->balance ?? 0) < 0)
                                    <strong class="text-success">Rs. {{ number_format(abs($party->balance), 2) }} (Adv)</strong>
                                @else
                                    <span class="text-muted">Rs. 0.00</span>
                                @endif
                            </td>
                            <td class="text-center">
                                <a href="{{ route('reports.ledger') }}?account={{ $party->id ?? 0 }}" class="btn btn-outline" style="padding: 0.25rem 0.5rem;" title="View Ledger">
                                    <i class="fas fa-file-alt"></i>
                                </a>
                                <a href="{{ route('parties.edit', $party->id ?? 0) }}" class="btn btn-outline" style="padding: 0.25rem 0.5rem;" title="Edit">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <form action="{{ route('parties.destroy', $party->id ?? 0) }}" method="POST" style="display: inline;">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-outline" style="padding: 0.25rem 0.5rem; color: var(--danger-color);" onclick="return confirm('Are you sure?')" title="Delete">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="text-center text-muted" style="padding: 3rem;">
                                <i class="fas fa-truck" style="font-size: 3rem; display: block; margin-bottom: 1rem; opacity: 0.5;"></i>
                                <p style="margin: 0;">No suppliers found. <a href="{{ route('parties.create') }}?type=supplier">Add your first supplier</a></p>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <!-- Summary -->
        <div style="display: flex; justify-content: flex-end; margin-top: 1rem; padding-top: 1rem; border-top: 1px solid var(--border-color);">
            <table style="width: 300px; border: none;">
                <tr>
                    <td style="padding: 0.5rem; border: none;">Total Suppliers:</td>
                    <td style="padding: 0.5rem; border: none; text-align: right;"><strong>{{ count($parties ?? []) }}</strong></td>
                </tr>
                <tr>
                    <td style="padding: 0.5rem; border: none;">Total Payable:</td>
                    <td style="padding: 0.5rem; border: none; text-align: right;"><strong class="text-danger">Rs. {{ number_format($totalPayable ?? 0, 2) }}</strong></td>
                </tr>
                <tr>
                    <td style="padding: 0.5rem; border: none;">Total Advance:</td>
                    <td style="padding: 0.5rem; border: none; text-align: right;"><strong class="text-success">Rs. {{ number_format($totalAdvance ?? 0, 2) }}</strong></td>
                </tr>
            </table>
        </div>
    </div>
</div>
@endsection
