<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'AccSoft') }} - Accounting Software</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=inter:400,500,600,700&display=swap" rel="stylesheet" />
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css?v={{ time() }}">
    
    <style>
        :root {
            --primary-color: #2563eb;
            --primary-hover: #1d4ed8;
            --secondary-color: #64748b;
            --success-color: #22c55e;
            --danger-color: #ef4444;
            --warning-color: #f59e0b;
            --info-color: #06b6d4;
            --light-bg: #f8fafc;
            --card-bg: #ffffff;
            --border-color: #e2e8f0;
            --text-primary: #1e293b;
            --text-secondary: #64748b;
            --sidebar-bg: #1e293b;
            --sidebar-hover: #334155;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', sans-serif;
            background-color: var(--light-bg);
            color: var(--text-primary);
        }

        /* Top Header Bar */
        .top-header {
            background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%);
            color: white;
            padding: 0.5rem 1rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 1000;
            height: 50px;
        }

        .top-header .logo {
            font-size: 1.25rem;
            font-weight: 700;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .top-header .logo i {
            font-size: 1.5rem;
        }

        /* Top Menu */
        .top-menu {
            display: flex;
            gap: 0.25rem;
        }

        .top-menu-item {
            padding: 0.5rem 1rem;
            color: rgba(255, 255, 255, 0.9);
            text-decoration: none;
            font-size: 0.875rem;
            font-weight: 500;
            border-radius: 0.375rem;
            transition: all 0.2s;
            position: relative;
            cursor: pointer;
        }

        .top-menu-item:hover {
            background-color: rgba(255, 255, 255, 0.15);
            color: white;
        }

        .top-menu-item.has-dropdown:hover .dropdown-menu,
        .top-menu-item.has-dropdown .dropdown-menu:hover {
            display: block;
        }

        .dropdown-menu {
            display: none;
            position: absolute;
            top: 100%;
            left: 0;
            background: white;
            min-width: 220px;
            border-radius: 0.5rem;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.15);
            padding: 0.5rem 0;
            z-index: 1001;
            padding-top: 0.75rem;
        }

        .dropdown-menu::before {
            content: '';
            position: absolute;
            top: -10px;
            left: 0;
            right: 0;
            height: 10px;
            background: transparent;
        }

        .dropdown-menu a {
            display: block;
            padding: 0.625rem 1rem;
            color: var(--text-primary);
            text-decoration: none;
            font-size: 0.875rem;
            transition: all 0.2s;
        }

        .dropdown-menu a:hover {
            background-color: var(--light-bg);
            color: var(--primary-color);
        }

        .dropdown-menu a i {
            width: 20px;
            margin-right: 0.5rem;
            color: var(--secondary-color);
        }

        .dropdown-divider {
            height: 1px;
            background-color: var(--border-color);
            margin: 0.5rem 0;
        }

        .user-menu {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .user-info {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.375rem 0.75rem;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 0.5rem;
            cursor: pointer;
            position: relative;
        }

        .user-info:hover .dropdown-menu {
            display: block;
        }

        .user-avatar {
            width: 32px;
            height: 32px;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 0.875rem;
        }

        /* Toolbar */
        .toolbar {
            background: white;
            border-bottom: 1px solid var(--border-color);
            padding: 0.5rem 1rem;
            position: fixed;
            top: 50px;
            left: 0;
            right: 0;
            z-index: 999;
            display: flex;
            gap: 0.25rem;
            flex-wrap: wrap;
        }

        .toolbar-btn {
            display: flex;
            flex-direction: column;
            align-items: center;
            padding: 0.5rem 0.75rem;
            background: linear-gradient(180deg, #f8fafc 0%, #e2e8f0 100%);
            border: 1px solid var(--border-color);
            border-radius: 0.375rem;
            cursor: pointer;
            transition: all 0.2s;
            text-decoration: none;
            color: var(--text-primary);
            min-width: 80px;
        }

        .toolbar-btn:hover {
            background: linear-gradient(180deg, #e2e8f0 0%, #cbd5e1 100%);
            border-color: #cbd5e1;
        }

        .toolbar-btn i {
            font-size: 1.25rem;
            margin-bottom: 0.25rem;
            color: var(--primary-color);
        }

        .toolbar-btn span {
            font-size: 0.75rem;
            font-weight: 500;
            text-align: center;
        }

        .toolbar-divider {
            width: 1px;
            background-color: var(--border-color);
            margin: 0 0.5rem;
        }

        /* Main Content */
        .main-wrapper {
            margin-top: 110px;
            padding: 1.5rem;
            padding-bottom: 70px;
            margin-bottom: 50px;
            min-height: calc(100vh - 110px - 50px);
        }

        /* Bottom Tab Bar */
        .bottom-tabs {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: white;
            border-top: 1px solid var(--border-color);
            display: flex;
            overflow-x: auto;
            z-index: 998;
            height: 50px;
        }

        .bottom-tab {
            padding: 0.75rem 1.25rem;
            color: var(--text-secondary);
            text-decoration: none;
            font-size: 0.8125rem;
            font-weight: 500;
            white-space: nowrap;
            border-right: 1px solid var(--border-color);
            transition: all 0.2s;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .bottom-tab:hover {
            background-color: var(--light-bg);
            color: var(--primary-color);
        }

        .bottom-tab.active {
            background-color: var(--primary-color);
            color: white;
        }

        .bottom-tab i {
            font-size: 1rem;
        }

        /* Cards */
        .card {
            background: white;
            border-radius: 0.75rem;
            border: 1px solid var(--border-color);
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.05);
        }

        .card-header {
            padding: 1rem 1.25rem;
            border-bottom: 1px solid var(--border-color);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .card-title {
            font-size: 1rem;
            font-weight: 600;
            color: var(--text-primary);
        }

        .card-body {
            padding: 1.25rem;
        }

        /* Buttons */
        .btn {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.5rem 1rem;
            font-size: 0.875rem;
            font-weight: 500;
            border-radius: 0.375rem;
            border: none;
            cursor: pointer;
            transition: all 0.2s;
            text-decoration: none;
        }

        .btn-primary {
            background-color: var(--primary-color);
            color: white;
        }

        .btn-primary:hover {
            background-color: var(--primary-hover);
        }

        .btn-success {
            background-color: var(--success-color);
            color: white;
        }

        .btn-danger {
            background-color: var(--danger-color);
            color: white;
        }

        .btn-secondary {
            background-color: var(--secondary-color);
            color: white;
        }

        .btn-outline {
            background-color: transparent;
            border: 1px solid var(--border-color);
            color: var(--text-primary);
        }

        .btn-outline:hover {
            background-color: var(--light-bg);
        }

        /* Tables */
        .table-responsive {
            overflow-x: auto;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        table th,
        table td {
            padding: 0.75rem 1rem;
            text-align: left;
            border-bottom: 1px solid var(--border-color);
        }

        table th {
            background-color: var(--light-bg);
            font-weight: 600;
            font-size: 0.8125rem;
            color: var(--text-secondary);
            text-transform: uppercase;
            letter-spacing: 0.05em;
        }

        table tbody tr:hover {
            background-color: #f1f5f9;
        }

        /* Forms */
        .form-group {
            margin-bottom: 1rem;
        }

        .form-label {
            display: block;
            margin-bottom: 0.375rem;
            font-size: 0.875rem;
            font-weight: 500;
            color: var(--text-primary);
        }

        .form-control {
            width: 100%;
            padding: 0.5rem 0.75rem;
            font-size: 0.875rem;
            border: 1px solid var(--border-color);
            border-radius: 0.375rem;
            transition: all 0.2s;
        }

        .form-control:focus {
            outline: none;
            border-color: var(--primary-color);
            box-shadow: 0 0 0 3px rgba(37, 99, 235, 0.1);
        }

        .form-row {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 1rem;
        }

        /* Stats Cards */
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
            gap: 1.5rem;
            margin-bottom: 1.5rem;
        }

        .stat-card {
            background: white;
            border-radius: 0.75rem;
            padding: 1.5rem;
            border: 1px solid var(--border-color);
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .stat-icon {
            width: 56px;
            height: 56px;
            border-radius: 0.75rem;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
        }

        .stat-icon.blue {
            background-color: #dbeafe;
            color: #2563eb;
        }

        .stat-icon.green {
            background-color: #dcfce7;
            color: #22c55e;
        }

        .stat-icon.yellow {
            background-color: #fef3c7;
            color: #f59e0b;
        }

        .stat-icon.red {
            background-color: #fee2e2;
            color: #ef4444;
        }

        .stat-content h3 {
            font-size: 1.5rem;
            font-weight: 700;
            color: var(--text-primary);
        }

        .stat-content p {
            font-size: 0.875rem;
            color: var(--text-secondary);
        }

        /* Alerts */
        .alert {
            padding: 1rem;
            border-radius: 0.5rem;
            margin-bottom: 1rem;
        }

        .alert-success {
            background-color: #dcfce7;
            color: #166534;
            border: 1px solid #86efac;
        }

        .alert-danger {
            background-color: #fee2e2;
            color: #991b1b;
            border: 1px solid #fecaca;
        }

        .alert-warning {
            background-color: #fef3c7;
            color: #92400e;
            border: 1px solid #fde68a;
        }

        .alert-info {
            background-color: #dbeafe;
            color: #1e40af;
            border: 1px solid #93c5fd;
        }

        /* Modal */
        .modal-backdrop {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(0, 0, 0, 0.5);
            display: none;
            align-items: center;
            justify-content: center;
            z-index: 2000;
        }

        .modal-backdrop.show {
            display: flex;
        }

        .modal {
            background: white;
            border-radius: 0.75rem;
            width: 100%;
            max-width: 500px;
            max-height: 90vh;
            overflow-y: auto;
        }

        .modal-header {
            padding: 1rem 1.25rem;
            border-bottom: 1px solid var(--border-color);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .modal-title {
            font-size: 1.125rem;
            font-weight: 600;
        }

        .modal-close {
            background: none;
            border: none;
            font-size: 1.25rem;
            cursor: pointer;
            color: var(--text-secondary);
        }

        .modal-body {
            padding: 1.25rem;
        }

        .modal-footer {
            padding: 1rem 1.25rem;
            border-top: 1px solid var(--border-color);
            display: flex;
            justify-content: flex-end;
            gap: 0.5rem;
        }

        /* Utility Classes */
        .text-center { text-align: center; }
        .text-right { text-align: right; }
        .text-primary { color: var(--primary-color); }
        .text-success { color: var(--success-color); }
        .text-danger { color: var(--danger-color); }
        .text-warning { color: var(--warning-color); }
        .text-muted { color: var(--text-secondary); }
        .mb-3 { margin-bottom: 1rem; }
        .mb-4 { margin-bottom: 1.5rem; }
        .mt-3 { margin-top: 1rem; }
        .mt-4 { margin-top: 1.5rem; }

        /* Responsive */
        
        /* Mobile Menu Button - Hidden by default, shown on mobile */
        .mobile-menu-btn {
            display: none;
            align-items: center;
            justify-content: center;
            width: 40px;
            height: 40px;
            background: rgba(255, 255, 255, 0.1);
            border: none;
            border-radius: 8px;
            color: white;
            font-size: 1.25rem;
            cursor: pointer;
        }
        
        /* Mobile Bottom Navigation - Hidden by default, shown on mobile */
        .mobile-bottom-nav {
            display: none;
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: white;
            border-top: 1px solid var(--border-color);
            z-index: 998;
            height: 60px;
            justify-content: space-around;
            align-items: center;
            padding: 0 0.5rem;
        }
        
        .mobile-nav-btn {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            padding: 0.5rem;
            color: var(--text-secondary);
            text-decoration: none;
            font-size: 0.625rem;
            font-weight: 500;
            min-width: 60px;
            border-radius: 8px;
            transition: all 0.2s;
            background: none;
            border: none;
            cursor: pointer;
        }
        
        .mobile-nav-btn.active {
            color: var(--primary-color);
        }
        
        .mobile-nav-btn i {
            font-size: 1.25rem;
            margin-bottom: 0.25rem;
        }
        
        .mobile-nav-btn:active {
            background: var(--light-bg);
        }
        
        /* Mobile Sidebar */
        .mobile-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.5);
            z-index: 1999;
        }
        
        .mobile-overlay.active {
            display: block;
        }
        
        .mobile-sidebar {
            position: fixed;
            top: 0;
            left: -280px;
            width: 280px;
            height: 100vh;
            background: white;
            z-index: 2000;
            transition: left 0.3s ease;
            overflow-y: auto;
        }
        
        .mobile-sidebar.active {
            left: 0;
        }
        
        .mobile-sidebar-header {
            background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%);
            color: white;
            padding: 1rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .mobile-sidebar-header .logo {
            font-size: 1.125rem;
            font-weight: 700;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        .mobile-sidebar-close {
            background: rgba(255, 255, 255, 0.2);
            border: none;
            color: white;
            width: 32px;
            height: 32px;
            border-radius: 8px;
            font-size: 1rem;
            cursor: pointer;
        }
        
        .mobile-nav-section {
            padding: 0.5rem 0;
            border-bottom: 1px solid var(--border-color);
        }
        
        .mobile-nav-title {
            padding: 0.5rem 1rem;
            font-size: 0.75rem;
            font-weight: 600;
            color: var(--text-secondary);
            text-transform: uppercase;
            letter-spacing: 0.05em;
        }
        
        .mobile-nav-item {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 0.75rem 1rem;
            color: var(--text-primary);
            text-decoration: none;
            font-size: 0.9375rem;
            transition: all 0.2s;
        }
        
        .mobile-nav-item:hover, .mobile-nav-item:active {
            background: var(--light-bg);
            color: var(--primary-color);
        }
        
        .mobile-nav-item i {
            width: 20px;
            text-align: center;
            color: var(--secondary-color);
        }
        
        .mobile-nav-item:hover i, .mobile-nav-item:active i {
            color: var(--primary-color);
        }
        
        /* MOBILE RESPONSIVE - This must come LAST */
        @media screen and (max-width: 768px) {
            .top-menu {
                display: none !important;
            }
            
            .toolbar {
                display: none !important;
            }
            
            .main-wrapper {
                margin-top: 50px;
                padding: 1rem;
                padding-bottom: 80px;
            }
            
            .user-info span {
                display: none;
            }
            
            .bottom-tabs {
                display: none !important;
            }
            
            .mobile-menu-btn {
                display: flex !important;
            }
            
            .mobile-bottom-nav {
                display: flex !important;
            }
        }
        
        /* DESKTOP - Hide mobile elements */
        @media screen and (min-width: 769px) {
            .mobile-bottom-nav {
                display: none !important;
            }
            
            .mobile-menu-btn {
                display: none !important;
            }
            
            .mobile-sidebar {
                display: none !important;
            }
            
            .mobile-overlay {
                display: none !important;
            }
        }
    </style>

    @stack('styles')
</head>
<body>
    <!-- Top Header -->
    <header class="top-header">
        <div style="display: flex; align-items: center; gap: 0.75rem;">
            <button class="mobile-menu-btn" onclick="toggleMobileSidebar()">
                <i class="fas fa-bars"></i>
            </button>
            <div class="logo">
                <i class="fas fa-calculator"></i>
                <span>HisaabPro</span>
            </div>
        </div>

        <nav class="top-menu">
            <a href="{{ route('dashboard') }}" class="top-menu-item">
                <i class="fas fa-home"></i> Dashboard
            </a>
            
            <div class="top-menu-item has-dropdown">
                CODE <i class="fas fa-chevron-down" style="font-size: 0.625rem; margin-left: 0.25rem;"></i>
                <div class="dropdown-menu">
                    <a href="{{ route('accounts.index') }}"><i class="fas fa-user-circle"></i> Chart of Accounts</a>
                    <a href="{{ route('items.index') }}"><i class="fas fa-box"></i> Items / Products</a>
                    <a href="{{ route('parties.index') }}"><i class="fas fa-users"></i> Parties</a>
                    <a href="{{ route('contracts.index') }}"><i class="fas fa-file-contract"></i> Contracts</a>
                    <div class="dropdown-divider"></div>
                    <a href="{{ route('settings.index') }}"><i class="fas fa-cog"></i> Settings</a>
                </div>
            </div>

            <div class="top-menu-item has-dropdown">
                TRANSACTION <i class="fas fa-chevron-down" style="font-size: 0.625rem; margin-left: 0.25rem;"></i>
                <div class="dropdown-menu">
                    <a href="{{ route('purchases.create') }}"><i class="fas fa-shopping-cart"></i> Purchase Bill</a>
                    <a href="{{ route('sales.create') }}"><i class="fas fa-receipt"></i> Sale Bill</a>
                    <div class="dropdown-divider"></div>
                    <a href="{{ route('vouchers.credit.create') }}"><i class="fas fa-plus-circle"></i> Credit Voucher</a>
                    <a href="{{ route('vouchers.debit.create') }}"><i class="fas fa-minus-circle"></i> Debit Voucher</a>
                    <a href="{{ route('vouchers.journal.create') }}"><i class="fas fa-book"></i> Journal Voucher</a>
                    <div class="dropdown-divider"></div>
                    <a href="{{ route('production.create') }}"><i class="fas fa-industry"></i> Production</a>
                </div>
            </div>

            <div class="top-menu-item has-dropdown">
                REPORT <i class="fas fa-chevron-down" style="font-size: 0.625rem; margin-left: 0.25rem;"></i>
                <div class="dropdown-menu">
                    <a href="{{ route('reports.daily-book') }}"><i class="fas fa-book-open"></i> Daily Book</a>
                    <a href="{{ route('reports.journal') }}"><i class="fas fa-journal-whills"></i> Journal Register</a>
                    <a href="{{ route('reports.ledger') }}"><i class="fas fa-file-alt"></i> A/C Ledger</a>
                    <div class="dropdown-divider"></div>
                    <a href="{{ route('reports.trial-balance') }}"><i class="fas fa-balance-scale"></i> Trial Balance</a>
                    <a href="{{ route('reports.cash-book') }}"><i class="fas fa-money-bill-wave"></i> Cash Book</a>
                    <a href="{{ route('reports.cash-flow') }}"><i class="fas fa-chart-line"></i> Cash Flow Statement</a>
                    <div class="dropdown-divider"></div>
                    <a href="{{ route('reports.profit-loss') }}"><i class="fas fa-chart-pie"></i> Profit & Loss</a>
                    <a href="{{ route('reports.balance-sheet') }}"><i class="fas fa-file-invoice-dollar"></i> Balance Sheet</a>
                    <div class="dropdown-divider"></div>
                    <a href="{{ route('reports.stock') }}"><i class="fas fa-warehouse"></i> Stock Sheet</a>
                    <a href="{{ route('reports.party-balance') }}"><i class="fas fa-users"></i> Party Balance</a>
                    <a href="{{ route('reports.aging') }}"><i class="fas fa-clock"></i> Aging Report</a>
                </div>
            </div>

            <div class="top-menu-item has-dropdown">
                USERS <i class="fas fa-chevron-down" style="font-size: 0.625rem; margin-left: 0.25rem;"></i>
                <div class="dropdown-menu">
                    <a href="{{ route('users.index') }}"><i class="fas fa-users-cog"></i> Manage Users</a>
                    <a href="{{ route('users.create') }}"><i class="fas fa-user-plus"></i> Create New User</a>
                    <a href="{{ route('roles.index') }}"><i class="fas fa-user-shield"></i> Roles & Permissions</a>
                </div>
            </div>

            <div class="top-menu-item has-dropdown">
                BACKUP <i class="fas fa-chevron-down" style="font-size: 0.625rem; margin-left: 0.25rem;"></i>
                <div class="dropdown-menu">
                    <a href="{{ route('backup.create') }}"><i class="fas fa-download"></i> Create Backup</a>
                    <a href="{{ route('backup.restore') }}"><i class="fas fa-upload"></i> Restore Backup</a>
                    <a href="{{ route('backup.list') }}"><i class="fas fa-list"></i> Backup History</a>
                </div>
            </div>
        </nav>

        <div class="user-menu">
            <div class="user-info has-dropdown">
                <div class="user-avatar">
                    <i class="fas fa-user"></i>
                </div>
                <span>{{ Auth::user()->name ?? 'User' }}</span>
                <i class="fas fa-chevron-down" style="font-size: 0.625rem;"></i>
                <div class="dropdown-menu" style="right: 0; left: auto;">
                    <a href="{{ route('profile.edit') }}"><i class="fas fa-user-circle"></i> My Profile</a>
                    <a href="{{ route('settings.company') }}"><i class="fas fa-building"></i> Company Settings</a>
                    <div class="dropdown-divider"></div>
                    <form action="{{ route('logout') }}" method="POST" style="margin: 0;">
                        @csrf
                        <a href="#" onclick="this.closest('form').submit(); return false;">
                            <i class="fas fa-sign-out-alt"></i> Logout
                        </a>
                    </form>
                </div>
            </div>
        </div>
    </header>

    <!-- Toolbar -->
    <div class="toolbar">
        <a href="{{ route('accounts.create') }}" class="toolbar-btn">
            <i class="fas fa-user-plus"></i>
            <span>New A/C</span>
        </a>
        <a href="{{ route('items.create') }}" class="toolbar-btn">
            <i class="fas fa-box"></i>
            <span>New Item</span>
        </a>
        <div class="toolbar-divider"></div>
        <a href="{{ route('purchases.create') }}" class="toolbar-btn">
            <i class="fas fa-shopping-cart"></i>
            <span>Purchase Bill</span>
        </a>
        <a href="{{ route('production.create') }}" class="toolbar-btn">
            <i class="fas fa-industry"></i>
            <span>Production</span>
        </a>
        <a href="{{ route('sales.create') }}" class="toolbar-btn">
            <i class="fas fa-receipt"></i>
            <span>Sale Bill</span>
        </a>
        <div class="toolbar-divider"></div>
        <a href="{{ route('vouchers.credit.create') }}" class="toolbar-btn">
            <i class="fas fa-plus-circle text-success"></i>
            <span>Credit Voucher</span>
        </a>
        <a href="{{ route('vouchers.debit.create') }}" class="toolbar-btn">
            <i class="fas fa-minus-circle text-danger"></i>
            <span>Debit Voucher</span>
        </a>
        <a href="{{ route('vouchers.journal.create') }}" class="toolbar-btn">
            <i class="fas fa-book"></i>
            <span>Journal Voucher</span>
        </a>
        <div class="toolbar-divider"></div>
        <a href="{{ route('reports.daily-book') }}" class="toolbar-btn">
            <i class="fas fa-book-open"></i>
            <span>Daily Book</span>
        </a>
    </div>

    <!-- Main Content -->
    <main class="main-wrapper">
        @if(session('success'))
            <div class="alert alert-success">
                <i class="fas fa-check-circle"></i> {{ session('success') }}
            </div>
        @endif

        @if(session('error'))
            <div class="alert alert-danger">
                <i class="fas fa-exclamation-circle"></i> {{ session('error') }}
            </div>
        @endif

        @yield('content')
    </main>

    <!-- Bottom Tabs -->
    <div class="bottom-tabs">
        <a href="{{ route('purchases.index') }}" class="bottom-tab {{ request()->routeIs('purchases.*') ? 'active' : '' }}">
            <i class="fas fa-file-invoice"></i> Purchase Register
        </a>
        <a href="{{ route('sales.index') }}" class="bottom-tab {{ request()->routeIs('sales.*') ? 'active' : '' }}">
            <i class="fas fa-receipt"></i> Sale Bill
        </a>
        <a href="{{ route('reports.cash-book') }}" class="bottom-tab {{ request()->routeIs('reports.cash-book') ? 'active' : '' }}">
            <i class="fas fa-money-bill-wave"></i> Cash Book
        </a>
        <a href="{{ route('reports.ledger') }}" class="bottom-tab {{ request()->routeIs('reports.ledger') ? 'active' : '' }}">
            <i class="fas fa-file-alt"></i> A/C Ledger
        </a>
        <a href="{{ route('parties.purchase') }}" class="bottom-tab {{ request()->routeIs('parties.purchase') ? 'active' : '' }}">
            <i class="fas fa-truck"></i> Purchase Party
        </a>
        <a href="{{ route('parties.sale') }}" class="bottom-tab {{ request()->routeIs('parties.sale') ? 'active' : '' }}">
            <i class="fas fa-store"></i> Sale Party
        </a>
        <a href="{{ route('reports.stock') }}" class="bottom-tab {{ request()->routeIs('reports.stock') ? 'active' : '' }}">
            <i class="fas fa-warehouse"></i> Stock Sheet
        </a>
        <a href="{{ route('reports.bill-wise-purchase') }}" class="bottom-tab {{ request()->routeIs('reports.bill-wise-purchase') ? 'active' : '' }}">
            <i class="fas fa-file-invoice-dollar"></i> Bill Wise Pur
        </a>
        <a href="{{ route('reports.bill-wise-sale') }}" class="bottom-tab {{ request()->routeIs('reports.bill-wise-sale') ? 'active' : '' }}">
            <i class="fas fa-file-invoice-dollar"></i> Bill Wise Sale
        </a>
    </div>

    @stack('scripts')
    
    <!-- Mobile Overlay -->
    <div class="mobile-overlay" id="mobileOverlay" onclick="toggleMobileSidebar()"></div>
    
    <!-- Mobile Sidebar -->
    <div class="mobile-sidebar" id="mobileSidebar">
        <div class="mobile-sidebar-header">
            <div class="logo">
                <i class="fas fa-calculator"></i>
                <span>HisaabPro</span>
            </div>
            <button class="mobile-sidebar-close" onclick="toggleMobileSidebar()">
                <i class="fas fa-times"></i>
            </button>
        </div>
        
        <div class="mobile-nav-section">
            <a href="{{ route('dashboard') }}" class="mobile-nav-item">
                <i class="fas fa-home"></i> Dashboard
            </a>
        </div>
        
        <div class="mobile-nav-section">
            <div class="mobile-nav-title">Master Data</div>
            <a href="{{ route('accounts.index') }}" class="mobile-nav-item">
                <i class="fas fa-user-circle"></i> Chart of Accounts
            </a>
            <a href="{{ route('items.index') }}" class="mobile-nav-item">
                <i class="fas fa-box"></i> Items / Products
            </a>
            <a href="{{ route('parties.index') }}" class="mobile-nav-item">
                <i class="fas fa-users"></i> Parties
            </a>
            <a href="{{ route('contracts.index') }}" class="mobile-nav-item">
                <i class="fas fa-file-contract"></i> Contracts
            </a>
        </div>
        
        <div class="mobile-nav-section">
            <div class="mobile-nav-title">Transactions</div>
            <a href="{{ route('purchases.create') }}" class="mobile-nav-item">
                <i class="fas fa-shopping-cart"></i> Purchase Bill
            </a>
            <a href="{{ route('sales.create') }}" class="mobile-nav-item">
                <i class="fas fa-receipt"></i> Sale Bill
            </a>
            <a href="{{ route('production.create') }}" class="mobile-nav-item">
                <i class="fas fa-industry"></i> Production
            </a>
            <a href="{{ route('vouchers.credit.create') }}" class="mobile-nav-item">
                <i class="fas fa-plus-circle"></i> Credit Voucher
            </a>
            <a href="{{ route('vouchers.debit.create') }}" class="mobile-nav-item">
                <i class="fas fa-minus-circle"></i> Debit Voucher
            </a>
            <a href="{{ route('vouchers.journal.create') }}" class="mobile-nav-item">
                <i class="fas fa-book"></i> Journal Voucher
            </a>
        </div>
        
        <div class="mobile-nav-section">
            <div class="mobile-nav-title">Reports</div>
            <a href="{{ route('reports.daily-book') }}" class="mobile-nav-item">
                <i class="fas fa-book-open"></i> Daily Book
            </a>
            <a href="{{ route('reports.ledger') }}" class="mobile-nav-item">
                <i class="fas fa-file-alt"></i> A/C Ledger
            </a>
            <a href="{{ route('reports.trial-balance') }}" class="mobile-nav-item">
                <i class="fas fa-balance-scale"></i> Trial Balance
            </a>
            <a href="{{ route('reports.cash-book') }}" class="mobile-nav-item">
                <i class="fas fa-money-bill-wave"></i> Cash Book
            </a>
            <a href="{{ route('reports.profit-loss') }}" class="mobile-nav-item">
                <i class="fas fa-chart-pie"></i> Profit & Loss
            </a>
            <a href="{{ route('reports.balance-sheet') }}" class="mobile-nav-item">
                <i class="fas fa-file-invoice-dollar"></i> Balance Sheet
            </a>
            <a href="{{ route('reports.stock') }}" class="mobile-nav-item">
                <i class="fas fa-warehouse"></i> Stock Sheet
            </a>
            <a href="{{ route('reports.party-balance') }}" class="mobile-nav-item">
                <i class="fas fa-users"></i> Party Balance
            </a>
        </div>
        
        <div class="mobile-nav-section">
            <div class="mobile-nav-title">Settings</div>
            <a href="{{ route('users.index') }}" class="mobile-nav-item">
                <i class="fas fa-users-cog"></i> Users
            </a>
            <a href="{{ route('settings.company') }}" class="mobile-nav-item">
                <i class="fas fa-building"></i> Company Settings
            </a>
            <a href="{{ route('backup.list') }}" class="mobile-nav-item">
                <i class="fas fa-database"></i> Backup
            </a>
            <a href="{{ route('profile.edit') }}" class="mobile-nav-item">
                <i class="fas fa-user-circle"></i> My Profile
            </a>
        </div>
        
        <div class="mobile-nav-section">
            <form action="{{ route('logout') }}" method="POST" style="margin: 0;">
                @csrf
                <a href="#" onclick="this.closest('form').submit(); return false;" class="mobile-nav-item" style="color: var(--danger-color);">
                    <i class="fas fa-sign-out-alt" style="color: var(--danger-color);"></i> Logout
                </a>
            </form>
        </div>
    </div>
    
    <!-- Mobile Bottom Navigation -->
    <nav class="mobile-bottom-nav">
        <a href="{{ route('dashboard') }}" class="mobile-nav-btn {{ request()->routeIs('dashboard') ? 'active' : '' }}">
            <i class="fas fa-home"></i>
            <span>Home</span>
        </a>
        <a href="{{ route('purchases.index') }}" class="mobile-nav-btn {{ request()->routeIs('purchases.*') ? 'active' : '' }}">
            <i class="fas fa-shopping-cart"></i>
            <span>Purchase</span>
        </a>
        <a href="{{ route('sales.index') }}" class="mobile-nav-btn {{ request()->routeIs('sales.*') ? 'active' : '' }}">
            <i class="fas fa-receipt"></i>
            <span>Sale</span>
        </a>
        <a href="{{ route('reports.ledger') }}" class="mobile-nav-btn {{ request()->routeIs('reports.ledger') ? 'active' : '' }}">
            <i class="fas fa-file-alt"></i>
            <span>Ledger</span>
        </a>
        <button class="mobile-nav-btn" onclick="toggleMobileSidebar()" style="background: none; border: none; cursor: pointer;">
            <i class="fas fa-bars"></i>
            <span>Menu</span>
        </button>
    </nav>
    
    <script>
        // Mobile sidebar toggle
        function toggleMobileSidebar() {
            document.getElementById('mobileSidebar').classList.toggle('active');
            document.getElementById('mobileOverlay').classList.toggle('active');
            document.body.style.overflow = document.getElementById('mobileSidebar').classList.contains('active') ? 'hidden' : '';
        }
        
        // Close sidebar on navigation
        document.querySelectorAll('.mobile-nav-item').forEach(function(item) {
            item.addEventListener('click', function() {
                if (window.innerWidth <= 768) {
                    toggleMobileSidebar();
                }
            });
        });
        
        // Toggle dropdown on click for touch devices
        document.querySelectorAll('.has-dropdown').forEach(function(dropdown) {
            dropdown.addEventListener('click', function(e) {
                if (window.innerWidth <= 768) {
                    e.preventDefault();
                    this.querySelector('.dropdown-menu').classList.toggle('show');
                }
            });
        });

        // Close dropdowns when clicking outside
        document.addEventListener('click', function(e) {
            if (!e.target.closest('.has-dropdown')) {
                document.querySelectorAll('.dropdown-menu.show').forEach(function(menu) {
                    menu.classList.remove('show');
                });
            }
        });
    </script>
</body>
</html>
