@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-plus-circle"></i> Create New Item</h3>
        <a href="{{ route('items.index') }}" class="btn btn-outline">
            <i class="fas fa-arrow-left"></i> Back
        </a>
    </div>
    <div class="card-body">
        @if($errors->any())
            <div style="background-color: #f8d7da; border: 1px solid #f5c6cb; color: #721c24; padding: 1rem; border-radius: 4px; margin-bottom: 1rem;">
                <strong><i class="fas fa-exclamation-triangle"></i> Please fix the following errors:</strong>
                <ul style="margin: 0.5rem 0 0 1.5rem;">
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form action="{{ route('items.store') }}" method="POST">
            @csrf
            
            <div class="form-row">
                <div class="form-group">
                    <label class="form-label" for="name">Item Name <span class="text-danger">*</span></label>
                    <input type="text" class="form-control @error('name') is-invalid @enderror" 
                           id="name" name="name" value="{{ old('name') }}" 
                           placeholder="e.g., Cotton Waste Grade A" required>
                    @error('name')
                        <span class="error-message">{{ $message }}</span>
                    @enderror
                </div>

                <div class="form-group">
                    <label class="form-label" for="type">Product Type <span class="text-danger">*</span></label>
                    <select class="form-control @error('type') is-invalid @enderror" 
                            id="type" name="type" required>
                        @foreach($types as $key => $value)
                            <option value="{{ $key }}" {{ old('type', 'raw') == $key ? 'selected' : '' }}>{{ $value }}</option>
                        @endforeach
                    </select>
                    @error('type')
                        <span class="error-message">{{ $message }}</span>
                    @enderror
                    <small style="color: #6c757d;">Code will be auto-generated based on type</small>
                </div>

                <div class="form-group">
                    <label class="form-label" for="unit">Unit <span class="text-danger">*</span></label>
                    <select class="form-control @error('unit') is-invalid @enderror" 
                            id="unit" name="unit" required>
                        <option value="">Select Unit</option>
                        @foreach($units as $unit)
                            <option value="{{ $unit }}" {{ old('unit', 'Kg') == $unit ? 'selected' : '' }}>
                                {{ $unit }}
                            </option>
                        @endforeach
                    </select>
                    @error('unit')
                        <span class="error-message">{{ $message }}</span>
                    @enderror
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label class="form-label" for="purchase_price">Purchase Price</label>
                    <input type="number" class="form-control @error('purchase_price') is-invalid @enderror" 
                           id="purchase_price" name="purchase_price" 
                           value="{{ old('purchase_price', 0) }}" step="0.01" min="0">
                    @error('purchase_price')
                        <span class="error-message">{{ $message }}</span>
                    @enderror
                </div>

                <div class="form-group">
                    <label class="form-label" for="sale_price">Sale Price</label>
                    <input type="number" class="form-control @error('sale_price') is-invalid @enderror" 
                           id="sale_price" name="sale_price" 
                           value="{{ old('sale_price', 0) }}" step="0.01" min="0">
                    @error('sale_price')
                        <span class="error-message">{{ $message }}</span>
                    @enderror
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label class="form-label" for="opening_stock">Opening Stock</label>
                    <input type="number" class="form-control @error('opening_stock') is-invalid @enderror" 
                           id="opening_stock" name="opening_stock" 
                           value="{{ old('opening_stock', 0) }}" step="0.01" min="0">
                    @error('opening_stock')
                        <span class="error-message">{{ $message }}</span>
                    @enderror
                </div>

                <div class="form-group">
                    <label class="form-label" for="minimum_stock">Minimum Stock Level</label>
                    <input type="number" class="form-control @error('minimum_stock') is-invalid @enderror" 
                           id="minimum_stock" name="minimum_stock" 
                           value="{{ old('minimum_stock', 0) }}" step="0.01" min="0" 
                           placeholder="Alert when stock falls below">
                    @error('minimum_stock')
                        <span class="error-message">{{ $message }}</span>
                    @enderror
                </div>
            </div>

            <div class="form-group">
                <label class="form-label" for="description">Description</label>
                <textarea class="form-control @error('description') is-invalid @enderror" 
                          id="description" name="description" rows="2" 
                          placeholder="Optional description...">{{ old('description') }}</textarea>
                @error('description')
                    <span class="error-message">{{ $message }}</span>
                @enderror
            </div>

            <div style="display: flex; gap: 0.5rem; margin-top: 1.5rem;">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> Save Item
                </button>
                <a href="{{ route('items.index') }}" class="btn btn-outline">
                    Cancel
                </a>
            </div>
        </form>
    </div>
</div>
@endsection
