@extends('layouts.app')

@section('title', 'Contract Details - ' . $contract->contract_no)

@section('content')
<div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
    <h2 style="margin: 0; color: #333;">
        <i class="fas fa-file-contract"></i> Contract: {{ $contract->contract_no }}
    </h2>
    <div>
        <a href="{{ route('contracts.print', $contract) }}" class="btn btn-secondary" target="_blank">
            <i class="fas fa-print"></i> Print
        </a>
        <a href="{{ route('contracts.edit', $contract) }}" class="btn btn-warning">
            <i class="fas fa-edit"></i> Edit
        </a>
        <a href="{{ route('contracts.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Back
        </a>
    </div>
</div>

<div style="display: grid; grid-template-columns: 2fr 1fr; gap: 20px;">
    <!-- Contract Details -->
    <div>
        <div style="background: white; padding: 20px; border-radius: 8px; box-shadow: 0 1px 3px rgba(0,0,0,0.1); margin-bottom: 20px;">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 15px;">
                <h4 style="margin: 0; color: #555;">Contract Information</h4>
                @php
                    $statusColors = [
                        'draft' => 'background: #fafafa; color: #666;',
                        'active' => 'background: #e8f5e9; color: #2e7d32;',
                        'completed' => 'background: #e3f2fd; color: #1565c0;',
                        'cancelled' => 'background: #ffebee; color: #c62828;',
                    ];
                @endphp
                <span style="{{ $statusColors[$contract->status] ?? '' }} padding: 5px 15px; border-radius: 20px; font-weight: 500;">
                    {{ ucfirst($contract->status) }}
                </span>
            </div>

            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px;">
                <div>
                    <table style="width: 100%;">
                        <tr>
                            <td style="padding: 8px 0; color: #666;">Contract No:</td>
                            <td style="padding: 8px 0; font-weight: 500;">{{ $contract->contract_no }}</td>
                        </tr>
                        <tr>
                            <td style="padding: 8px 0; color: #666;">Title:</td>
                            <td style="padding: 8px 0; font-weight: 500;">{{ $contract->title }}</td>
                        </tr>
                        <tr>
                            <td style="padding: 8px 0; color: #666;">Type:</td>
                            <td style="padding: 8px 0;">
                                @if($contract->type == 'purchase')
                                    <span style="background: #e3f2fd; color: #1565c0; padding: 3px 8px; border-radius: 4px;">Purchase</span>
                                @else
                                    <span style="background: #e8f5e9; color: #2e7d32; padding: 3px 8px; border-radius: 4px;">Sale</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <td style="padding: 8px 0; color: #666;">Party:</td>
                            <td style="padding: 8px 0; font-weight: 500;">
                                <a href="{{ route('parties.show', $contract->party) }}">{{ $contract->party->name ?? '-' }}</a>
                            </td>
                        </tr>
                        <tr>
                            <td style="padding: 8px 0; color: #666;">Item:</td>
                            <td style="padding: 8px 0;">{{ $contract->item->name ?? 'General Contract' }}</td>
                        </tr>
                    </table>
                </div>
                <div>
                    <table style="width: 100%;">
                        <tr>
                            <td style="padding: 8px 0; color: #666;">Start Date:</td>
                            <td style="padding: 8px 0; font-weight: 500;">{{ $contract->start_date->format('d M, Y') }}</td>
                        </tr>
                        <tr>
                            <td style="padding: 8px 0; color: #666;">End Date:</td>
                            <td style="padding: 8px 0;">
                                {{ $contract->end_date ? $contract->end_date->format('d M, Y') : 'Open Ended' }}
                                @if($contract->is_expired)
                                    <span style="background: #ffebee; color: #c62828; padding: 2px 6px; border-radius: 4px; font-size: 11px; margin-left: 5px;">Expired</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <td style="padding: 8px 0; color: #666;">Agent Commission:</td>
                            <td style="padding: 8px 0;">{{ number_format($contract->agent_commission_rate, 2) }} / unit</td>
                        </tr>
                        <tr>
                            <td style="padding: 8px 0; color: #666;">Transport Rate:</td>
                            <td style="padding: 8px 0;">{{ number_format($contract->transport_rate, 2) }} / unit</td>
                        </tr>
                        <tr>
                            <td style="padding: 8px 0; color: #666;">Created By:</td>
                            <td style="padding: 8px 0;">{{ $contract->creator->name ?? '-' }}</td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>

        <!-- Terms & Remarks -->
        @if($contract->terms || $contract->remarks)
        <div style="background: white; padding: 20px; border-radius: 8px; box-shadow: 0 1px 3px rgba(0,0,0,0.1); margin-bottom: 20px;">
            @if($contract->terms)
            <div style="margin-bottom: 15px;">
                <h5 style="margin: 0 0 10px 0; color: #555;">Terms & Conditions</h5>
                <p style="margin: 0; color: #666; white-space: pre-line;">{{ $contract->terms }}</p>
            </div>
            @endif
            @if($contract->remarks)
            <div>
                <h5 style="margin: 0 0 10px 0; color: #555;">Remarks</h5>
                <p style="margin: 0; color: #666;">{{ $contract->remarks }}</p>
            </div>
            @endif
        </div>
        @endif

        <!-- Related Transactions -->
        <div style="background: white; padding: 20px; border-radius: 8px; box-shadow: 0 1px 3px rgba(0,0,0,0.1);">
            <h4 style="margin-top: 0; margin-bottom: 15px; color: #555;">
                Related {{ $contract->type == 'purchase' ? 'Purchases' : 'Sales' }}
            </h4>

            @if($relatedTransactions->count() > 0)
            <table class="table" style="margin: 0;">
                <thead>
                    <tr style="background: #f8f9fa;">
                        <th>{{ $contract->type == 'purchase' ? 'Bill' : 'Invoice' }} No</th>
                        <th>Date</th>
                        <th style="text-align: right;">Quantity</th>
                        <th style="text-align: right;">Amount</th>
                        <th style="text-align: center;">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($relatedTransactions as $transaction)
                    <tr>
                        <td>{{ $transaction->bill_no ?? $transaction->invoice_no }}</td>
                        <td>{{ $transaction->date->format('d M, Y') }}</td>
                        <td style="text-align: right;">
                            {{ number_format($transaction->items->sum('quantity'), 2) }}
                        </td>
                        <td style="text-align: right;">{{ number_format($transaction->total_amount, 2) }}</td>
                        <td style="text-align: center;">
                            @if($contract->type == 'purchase')
                            <a href="{{ route('purchases.show', $transaction) }}" class="btn btn-sm btn-info">
                                <i class="fas fa-eye"></i>
                            </a>
                            @else
                            <a href="{{ route('sales.show', $transaction) }}" class="btn btn-sm btn-info">
                                <i class="fas fa-eye"></i>
                            </a>
                            @endif
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
            @else
            <p style="text-align: center; color: #666; padding: 20px;">
                No {{ $contract->type == 'purchase' ? 'purchases' : 'sales' }} linked to this contract yet.
            </p>
            @endif
        </div>
    </div>

    <!-- Summary Panel -->
    <div>
        <!-- Progress Card -->
        <div style="background: white; padding: 20px; border-radius: 8px; box-shadow: 0 1px 3px rgba(0,0,0,0.1); margin-bottom: 20px;">
            <h4 style="margin-top: 0; margin-bottom: 15px; color: #555;">Delivery Progress</h4>
            
            <div style="margin-bottom: 15px;">
                <div style="display: flex; justify-content: space-between; margin-bottom: 5px;">
                    <span>Progress</span>
                    <strong>{{ $contract->completion_percentage }}%</strong>
                </div>
                <div style="background: #eee; border-radius: 10px; height: 20px; overflow: hidden;">
                    <div style="background: linear-gradient(135deg, #11998e, #38ef7d); height: 100%; width: {{ $contract->completion_percentage }}%; transition: width 0.3s;"></div>
                </div>
            </div>

            <table style="width: 100%;">
                <tr>
                    <td style="padding: 8px 0; color: #666;">Agreed Quantity:</td>
                    <td style="padding: 8px 0; text-align: right; font-weight: 500;">
                        {{ number_format($contract->agreed_quantity, 2) }} {{ $contract->quantity_unit }}
                    </td>
                </tr>
                <tr>
                    <td style="padding: 8px 0; color: #2e7d32;">Delivered:</td>
                    <td style="padding: 8px 0; text-align: right; font-weight: 500; color: #2e7d32;">
                        {{ number_format($contract->delivered_quantity, 2) }} {{ $contract->quantity_unit }}
                    </td>
                </tr>
                <tr>
                    <td style="padding: 8px 0; color: #c62828;">Pending:</td>
                    <td style="padding: 8px 0; text-align: right; font-weight: 500; color: #c62828;">
                        {{ number_format($contract->pending_quantity, 2) }} {{ $contract->quantity_unit }}
                    </td>
                </tr>
            </table>
        </div>

        <!-- Value Summary -->
        <div style="background: white; padding: 20px; border-radius: 8px; box-shadow: 0 1px 3px rgba(0,0,0,0.1);">
            <h4 style="margin-top: 0; margin-bottom: 15px; color: #555;">Value Summary</h4>

            <div style="background: #f8f9fa; padding: 15px; border-radius: 6px;">
                <div style="display: flex; justify-content: space-between; margin-bottom: 10px;">
                    <span>Rate Per Unit:</span>
                    <strong>{{ number_format($contract->agreed_rate, 2) }}</strong>
                </div>
                <hr style="margin: 10px 0; border: none; border-top: 1px solid #ddd;">
                <div style="display: flex; justify-content: space-between; margin-bottom: 10px;">
                    <span>Contract Value:</span>
                    <strong>{{ number_format($contract->contract_value, 2) }}</strong>
                </div>
                <div style="display: flex; justify-content: space-between; margin-bottom: 10px;">
                    <span style="color: #2e7d32;">Delivered Value:</span>
                    <strong style="color: #2e7d32;">{{ number_format($contract->delivered_value, 2) }}</strong>
                </div>
                <div style="display: flex; justify-content: space-between;">
                    <span style="color: #c62828;">Pending Value:</span>
                    <strong style="color: #c62828;">{{ number_format($contract->pending_value, 2) }}</strong>
                </div>
            </div>

            @if($contract->status == 'active' && $contract->pending_quantity > 0)
            <div style="margin-top: 15px;">
                @if($contract->type == 'purchase')
                <a href="{{ route('purchases.create', ['contract_id' => $contract->id]) }}" class="btn btn-primary" style="width: 100%;">
                    <i class="fas fa-plus"></i> Create Purchase
                </a>
                @else
                <a href="{{ route('sales.create', ['contract_id' => $contract->id]) }}" class="btn btn-success" style="width: 100%;">
                    <i class="fas fa-plus"></i> Create Sale
                </a>
                @endif
            </div>
            @endif
        </div>
    </div>
</div>
@endsection
