@extends('layouts.app')

@section('title', 'Contracts')

@section('content')
<div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
    <h2 style="margin: 0; color: #333;">Contracts Management</h2>
    <div>
        <a href="{{ route('contracts.create', ['type' => 'purchase']) }}" class="btn btn-primary" style="margin-right: 5px;">
            <i class="fas fa-plus"></i> Purchase Contract
        </a>
        <a href="{{ route('contracts.create', ['type' => 'sale']) }}" class="btn btn-success">
            <i class="fas fa-plus"></i> Sale Contract
        </a>
    </div>
</div>

<!-- Summary Cards -->
<div style="display: grid; grid-template-columns: repeat(4, 1fr); gap: 15px; margin-bottom: 20px;">
    <div style="background: linear-gradient(135deg, #667eea, #764ba2); color: white; padding: 20px; border-radius: 8px;">
        <div style="font-size: 24px; font-weight: bold;">{{ $summary['total_contracts'] }}</div>
        <div style="opacity: 0.9;">Total Contracts</div>
    </div>
    <div style="background: linear-gradient(135deg, #11998e, #38ef7d); color: white; padding: 20px; border-radius: 8px;">
        <div style="font-size: 24px; font-weight: bold;">{{ $summary['active_contracts'] }}</div>
        <div style="opacity: 0.9;">Active Contracts</div>
    </div>
    <div style="background: linear-gradient(135deg, #ee9ca7, #ffdde1); color: #333; padding: 20px; border-radius: 8px;">
        <div style="font-size: 24px; font-weight: bold;">{{ number_format($summary['total_value'], 0) }}</div>
        <div style="opacity: 0.9;">Total Contract Value</div>
    </div>
    <div style="background: linear-gradient(135deg, #a8edea, #fed6e3); color: #333; padding: 20px; border-radius: 8px;">
        <div style="font-size: 24px; font-weight: bold;">{{ number_format($summary['pending_value'], 0) }}</div>
        <div style="opacity: 0.9;">Pending Value</div>
    </div>
</div>

<!-- Filters -->
<div style="background: white; padding: 15px; border-radius: 8px; margin-bottom: 20px; box-shadow: 0 1px 3px rgba(0,0,0,0.1);">
    <form method="GET" action="{{ route('contracts.index') }}" style="display: flex; gap: 15px; flex-wrap: wrap; align-items: end;">
        <div style="flex: 1; min-width: 150px;">
            <label style="display: block; margin-bottom: 5px; font-weight: 500; color: #555;">Type</label>
            <select name="type" class="form-control">
                <option value="">All Types</option>
                @foreach(App\Models\Contract::TYPES as $key => $label)
                    <option value="{{ $key }}" {{ request('type') == $key ? 'selected' : '' }}>{{ $label }}</option>
                @endforeach
            </select>
        </div>
        <div style="flex: 1; min-width: 150px;">
            <label style="display: block; margin-bottom: 5px; font-weight: 500; color: #555;">Status</label>
            <select name="status" class="form-control">
                <option value="">All Status</option>
                @foreach(App\Models\Contract::STATUSES as $key => $label)
                    <option value="{{ $key }}" {{ request('status') == $key ? 'selected' : '' }}>{{ $label }}</option>
                @endforeach
            </select>
        </div>
        <div style="flex: 1; min-width: 200px;">
            <label style="display: block; margin-bottom: 5px; font-weight: 500; color: #555;">Party</label>
            <select name="party_id" class="form-control">
                <option value="">All Parties</option>
                @foreach($parties as $party)
                    <option value="{{ $party->id }}" {{ request('party_id') == $party->id ? 'selected' : '' }}>{{ $party->name }}</option>
                @endforeach
            </select>
        </div>
        <div style="flex: 1; min-width: 200px;">
            <label style="display: block; margin-bottom: 5px; font-weight: 500; color: #555;">Search</label>
            <input type="text" name="search" class="form-control" placeholder="Contract No, Title..." value="{{ request('search') }}">
        </div>
        <div>
            <button type="submit" class="btn btn-primary">
                <i class="fas fa-search"></i> Filter
            </button>
            <a href="{{ route('contracts.index') }}" class="btn btn-secondary">
                <i class="fas fa-times"></i> Clear
            </a>
        </div>
    </form>
</div>

<!-- Contracts Table -->
<div style="background: white; border-radius: 8px; box-shadow: 0 1px 3px rgba(0,0,0,0.1); overflow: hidden;">
    <table class="table" style="margin: 0;">
        <thead>
            <tr style="background: #f8f9fa;">
                <th>Contract No</th>
                <th>Title</th>
                <th>Party</th>
                <th>Type</th>
                <th>Item</th>
                <th style="text-align: right;">Rate</th>
                <th style="text-align: right;">Agreed Qty</th>
                <th style="text-align: right;">Delivered</th>
                <th style="text-align: right;">Pending</th>
                <th>Status</th>
                <th style="text-align: center;">Actions</th>
            </tr>
        </thead>
        <tbody>
            @forelse($contracts as $contract)
            <tr>
                <td>
                    <a href="{{ route('contracts.show', $contract) }}" style="font-weight: 500; color: #007bff;">
                        {{ $contract->contract_no }}
                    </a>
                </td>
                <td>{{ Str::limit($contract->title, 30) }}</td>
                <td>{{ $contract->party->name ?? '-' }}</td>
                <td>
                    @if($contract->type == 'purchase')
                        <span style="background: #e3f2fd; color: #1565c0; padding: 3px 8px; border-radius: 4px; font-size: 11px;">
                            Purchase
                        </span>
                    @else
                        <span style="background: #e8f5e9; color: #2e7d32; padding: 3px 8px; border-radius: 4px; font-size: 11px;">
                            Sale
                        </span>
                    @endif
                </td>
                <td>{{ $contract->item->name ?? 'General' }}</td>
                <td style="text-align: right;">{{ number_format($contract->agreed_rate, 2) }}</td>
                <td style="text-align: right;">{{ number_format($contract->agreed_quantity, 2) }} {{ $contract->quantity_unit }}</td>
                <td style="text-align: right; color: #2e7d32;">{{ number_format($contract->delivered_quantity, 2) }}</td>
                <td style="text-align: right; color: #c62828;">{{ number_format($contract->pending_quantity, 2) }}</td>
                <td>
                    @php
                        $statusColors = [
                            'draft' => 'background: #fafafa; color: #666;',
                            'active' => 'background: #e8f5e9; color: #2e7d32;',
                            'completed' => 'background: #e3f2fd; color: #1565c0;',
                            'cancelled' => 'background: #ffebee; color: #c62828;',
                        ];
                    @endphp
                    <span style="{{ $statusColors[$contract->status] ?? '' }} padding: 3px 8px; border-radius: 4px; font-size: 11px;">
                        {{ ucfirst($contract->status) }}
                    </span>
                </td>
                <td style="text-align: center;">
                    <div style="display: flex; gap: 5px; justify-content: center;">
                        <a href="{{ route('contracts.show', $contract) }}" class="btn btn-sm btn-info" title="View">
                            <i class="fas fa-eye"></i>
                        </a>
                        <a href="{{ route('contracts.edit', $contract) }}" class="btn btn-sm btn-warning" title="Edit">
                            <i class="fas fa-edit"></i>
                        </a>
                        <a href="{{ route('contracts.print', $contract) }}" class="btn btn-sm btn-secondary" title="Print" target="_blank">
                            <i class="fas fa-print"></i>
                        </a>
                        @if($contract->delivered_quantity == 0)
                        <form action="{{ route('contracts.destroy', $contract) }}" method="POST" style="display: inline;" 
                              onsubmit="return confirm('Are you sure you want to delete this contract?')">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-sm btn-danger" title="Delete">
                                <i class="fas fa-trash"></i>
                            </button>
                        </form>
                        @endif
                    </div>
                </td>
            </tr>
            @empty
            <tr>
                <td colspan="11" style="text-align: center; padding: 40px; color: #666;">
                    <i class="fas fa-file-contract" style="font-size: 48px; color: #ddd; margin-bottom: 10px;"></i>
                    <p>No contracts found.</p>
                </td>
            </tr>
            @endforelse
        </tbody>
    </table>
</div>

<!-- Pagination -->
<div style="margin-top: 20px; display: flex; justify-content: center;">
    {{ $contracts->appends(request()->query())->links() }}
</div>
@endsection
