@extends('layouts.app')

@section('title', 'Edit Contract - ' . $contract->contract_no)

@section('content')
<div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
    <h2 style="margin: 0; color: #333;">
        <i class="fas fa-edit"></i> Edit Contract: {{ $contract->contract_no }}
    </h2>
    <a href="{{ route('contracts.show', $contract) }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Back to Contract
    </a>
</div>

<form action="{{ route('contracts.update', $contract) }}" method="POST">
    @csrf
    @method('PUT')

    <div style="display: grid; grid-template-columns: 2fr 1fr; gap: 20px;">
        <!-- Main Form -->
        <div style="background: white; padding: 20px; border-radius: 8px; box-shadow: 0 1px 3px rgba(0,0,0,0.1);">
            <h4 style="margin-top: 0; margin-bottom: 15px; color: #555; border-bottom: 1px solid #eee; padding-bottom: 10px;">
                Contract Details
            </h4>

            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px;">
                <div class="form-group">
                    <label style="display: block; margin-bottom: 5px; font-weight: 500;">Contract No</label>
                    <input type="text" class="form-control" value="{{ $contract->contract_no }}" 
                           style="background: #f5f5f5;" readonly>
                </div>

                <div class="form-group">
                    <label style="display: block; margin-bottom: 5px; font-weight: 500;">Type</label>
                    <input type="text" class="form-control" value="{{ ucfirst($contract->type) }} Contract" 
                           style="background: #f5f5f5;" readonly>
                </div>
            </div>

            <div class="form-group" style="margin-top: 15px;">
                <label style="display: block; margin-bottom: 5px; font-weight: 500;">Contract Title *</label>
                <input type="text" name="title" class="form-control @error('title') is-invalid @enderror" 
                       value="{{ old('title', $contract->title) }}" required>
                @error('title')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="form-group" style="margin-top: 15px;">
                <label style="display: block; margin-bottom: 5px; font-weight: 500;">Party *</label>
                <select name="party_id" class="form-control @error('party_id') is-invalid @enderror" required>
                    <option value="">Select Party</option>
                    @foreach($parties as $party)
                        <option value="{{ $party->id }}" {{ old('party_id', $contract->party_id) == $party->id ? 'selected' : '' }}>
                            {{ $party->name }}
                        </option>
                    @endforeach
                </select>
                @error('party_id')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="form-group" style="margin-top: 15px;">
                <label style="display: block; margin-bottom: 5px; font-weight: 500;">Status *</label>
                <select name="status" class="form-control">
                    @foreach(App\Models\Contract::STATUSES as $key => $label)
                        <option value="{{ $key }}" {{ old('status', $contract->status) == $key ? 'selected' : '' }}>{{ $label }}</option>
                    @endforeach
                </select>
            </div>

            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px; margin-top: 15px;">
                <div class="form-group">
                    <label style="display: block; margin-bottom: 5px; font-weight: 500;">Start Date *</label>
                    <input type="date" name="start_date" class="form-control @error('start_date') is-invalid @enderror" 
                           value="{{ old('start_date', $contract->start_date->format('Y-m-d')) }}" required>
                    @error('start_date')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="form-group">
                    <label style="display: block; margin-bottom: 5px; font-weight: 500;">End Date</label>
                    <input type="date" name="end_date" class="form-control @error('end_date') is-invalid @enderror" 
                           value="{{ old('end_date', $contract->end_date ? $contract->end_date->format('Y-m-d') : '') }}">
                    @error('end_date')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>

            <div class="form-group" style="margin-top: 15px;">
                <label style="display: block; margin-bottom: 5px; font-weight: 500;">Item</label>
                <select name="item_id" class="form-control">
                    <option value="">General Contract (No Specific Item)</option>
                    @foreach($items as $item)
                        <option value="{{ $item->id }}" {{ old('item_id', $contract->item_id) == $item->id ? 'selected' : '' }}>
                            {{ $item->name }}
                        </option>
                    @endforeach
                </select>
            </div>

            <h4 style="margin-top: 25px; margin-bottom: 15px; color: #555; border-bottom: 1px solid #eee; padding-bottom: 10px;">
                Quantity & Pricing
            </h4>

            <div style="display: grid; grid-template-columns: 1fr 1fr 1fr; gap: 15px;">
                <div class="form-group">
                    <label style="display: block; margin-bottom: 5px; font-weight: 500;">Agreed Quantity *</label>
                    <input type="number" name="agreed_quantity" class="form-control @error('agreed_quantity') is-invalid @enderror" 
                           value="{{ old('agreed_quantity', $contract->agreed_quantity) }}" step="0.001" min="0" required id="agreedQuantity">
                    @error('agreed_quantity')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="form-group">
                    <label style="display: block; margin-bottom: 5px; font-weight: 500;">Unit *</label>
                    <select name="quantity_unit" class="form-control" required>
                        @foreach(App\Models\Contract::UNITS as $key => $label)
                            <option value="{{ $key }}" {{ old('quantity_unit', $contract->quantity_unit) == $key ? 'selected' : '' }}>{{ $label }}</option>
                        @endforeach
                    </select>
                </div>

                <div class="form-group">
                    <label style="display: block; margin-bottom: 5px; font-weight: 500;">Agreed Rate (Per Unit) *</label>
                    <input type="number" name="agreed_rate" class="form-control @error('agreed_rate') is-invalid @enderror" 
                           value="{{ old('agreed_rate', $contract->agreed_rate) }}" step="0.01" min="0" required id="agreedRate">
                    @error('agreed_rate')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>

            <!-- Delivery Info (Read Only) -->
            @if($contract->delivered_quantity > 0)
            <div style="background: #fff3cd; padding: 15px; border-radius: 6px; margin-top: 15px;">
                <strong><i class="fas fa-info-circle"></i> Delivery Information</strong>
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px; margin-top: 10px;">
                    <div>
                        <span style="color: #666;">Delivered Quantity:</span>
                        <strong style="color: #2e7d32;">{{ number_format($contract->delivered_quantity, 2) }} {{ $contract->quantity_unit }}</strong>
                    </div>
                    <div>
                        <span style="color: #666;">Pending Quantity:</span>
                        <strong style="color: #c62828;">{{ number_format($contract->pending_quantity, 2) }} {{ $contract->quantity_unit }}</strong>
                    </div>
                </div>
            </div>
            @endif

            <h4 style="margin-top: 25px; margin-bottom: 15px; color: #555; border-bottom: 1px solid #eee; padding-bottom: 10px;">
                Additional Rates
            </h4>

            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px;">
                <div class="form-group">
                    <label style="display: block; margin-bottom: 5px; font-weight: 500;">Agent Commission (Per Unit)</label>
                    <input type="number" name="agent_commission_rate" class="form-control" 
                           value="{{ old('agent_commission_rate', $contract->agent_commission_rate) }}" step="0.01" min="0">
                </div>

                <div class="form-group">
                    <label style="display: block; margin-bottom: 5px; font-weight: 500;">Transport Rate (Per Unit)</label>
                    <input type="number" name="transport_rate" class="form-control" 
                           value="{{ old('transport_rate', $contract->transport_rate) }}" step="0.01" min="0">
                </div>
            </div>

            <div class="form-group" style="margin-top: 15px;">
                <label style="display: block; margin-bottom: 5px; font-weight: 500;">Terms & Conditions</label>
                <textarea name="terms" class="form-control" rows="3">{{ old('terms', $contract->terms) }}</textarea>
            </div>

            <div class="form-group" style="margin-top: 15px;">
                <label style="display: block; margin-bottom: 5px; font-weight: 500;">Remarks</label>
                <textarea name="remarks" class="form-control" rows="2">{{ old('remarks', $contract->remarks) }}</textarea>
            </div>
        </div>

        <!-- Summary Panel -->
        <div>
            <div style="background: white; padding: 20px; border-radius: 8px; box-shadow: 0 1px 3px rgba(0,0,0,0.1); position: sticky; top: 20px;">
                <h4 style="margin-top: 0; margin-bottom: 15px; color: #555;">Contract Summary</h4>
                
                <div style="background: #f8f9fa; padding: 15px; border-radius: 6px;">
                    <div style="display: flex; justify-content: space-between; margin-bottom: 10px;">
                        <span>Contract Type:</span>
                        <strong style="color: {{ $contract->type == 'purchase' ? '#1565c0' : '#2e7d32' }};">
                            {{ ucfirst($contract->type) }}
                        </strong>
                    </div>
                    <div style="display: flex; justify-content: space-between; margin-bottom: 10px;">
                        <span>Quantity:</span>
                        <strong id="summaryQuantity">{{ number_format($contract->agreed_quantity, 2) }}</strong>
                    </div>
                    <div style="display: flex; justify-content: space-between; margin-bottom: 10px;">
                        <span>Rate:</span>
                        <strong id="summaryRate">{{ number_format($contract->agreed_rate, 2) }}</strong>
                    </div>
                    <hr style="margin: 10px 0;">
                    <div style="display: flex; justify-content: space-between; font-size: 18px;">
                        <span>Total Value:</span>
                        <strong style="color: #2e7d32;" id="summaryTotal">{{ number_format($contract->contract_value, 2) }}</strong>
                    </div>
                </div>

                <div style="margin-top: 20px;">
                    <button type="submit" class="btn btn-primary" style="width: 100%;">
                        <i class="fas fa-save"></i> Update Contract
                    </button>
                </div>
            </div>
        </div>
    </div>
</form>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const quantityInput = document.getElementById('agreedQuantity');
    const rateInput = document.getElementById('agreedRate');

    function updateSummary() {
        const quantity = parseFloat(quantityInput.value) || 0;
        const rate = parseFloat(rateInput.value) || 0;
        const total = quantity * rate;

        document.getElementById('summaryQuantity').textContent = quantity.toLocaleString('en-US', {minimumFractionDigits: 2});
        document.getElementById('summaryRate').textContent = rate.toLocaleString('en-US', {minimumFractionDigits: 2});
        document.getElementById('summaryTotal').textContent = total.toLocaleString('en-US', {minimumFractionDigits: 2});
    }

    quantityInput.addEventListener('input', updateSummary);
    rateInput.addEventListener('input', updateSummary);
});
</script>
@endsection
