@extends('layouts.guest')

@section('content')
<div class="auth-form-header">
    <h2>Welcome Back!</h2>
    <p>Please sign in to your account</p>
</div>

@if($errors->any())
    <div class="alert alert-danger">
        <i class="fas fa-exclamation-circle"></i>
        @foreach ($errors->all() as $error)
            {{ $error }}
        @endforeach
    </div>
@endif

@if(session('status'))
    <div class="alert alert-success">
        <i class="fas fa-check-circle"></i> {{ session('status') }}
    </div>
@endif

<form method="POST" action="{{ route('login') }}">
    @csrf
    
    <div class="form-group">
        <label class="form-label" for="email">Email Address</label>
        <div class="input-group">
            <i class="fas fa-envelope"></i>
            <input type="email" 
                   id="email" 
                   name="email" 
                   class="form-control" 
                   placeholder="Enter your email"
                   value="{{ old('email') }}"
                   required 
                   autofocus>
        </div>
        @error('email')
            <span class="error-message">{{ $message }}</span>
        @enderror
    </div>

    <div class="form-group">
        <label class="form-label" for="password">Password</label>
        <div class="input-group">
            <i class="fas fa-lock"></i>
            <input type="password" 
                   id="password" 
                   name="password" 
                   class="form-control" 
                   placeholder="Enter your password"
                   required>
        </div>
        @error('password')
            <span class="error-message">{{ $message }}</span>
        @enderror
    </div>

    <div class="form-check">
        <input type="checkbox" id="remember" name="remember" {{ old('remember') ? 'checked' : '' }}>
        <label for="remember">Remember me</label>
        <a href="{{ route('password.request') }}" class="forgot-link">Forgot Password?</a>
    </div>

    <button type="submit" class="btn-login">
        <i class="fas fa-sign-in-alt"></i> Sign In
    </button>
</form>

<div class="auth-footer">
    <p>Don't have an account? <a href="{{ route('register') }}">Create Account</a></p>
</div>
@endsection
