@extends('layouts.guest')

@section('content')
<div class="auth-form-header">
    <h2>Forgot Password?</h2>
    <p>Enter your email to receive a password reset link</p>
</div>

@if(session('status'))
    <div class="alert alert-success">
        <i class="fas fa-check-circle"></i> {{ session('status') }}
    </div>
@endif

@if($errors->any())
    <div class="alert alert-danger">
        <i class="fas fa-exclamation-circle"></i>
        @foreach ($errors->all() as $error)
            {{ $error }}
        @endforeach
    </div>
@endif

<form method="POST" action="{{ route('password.email') }}">
    @csrf
    
    <div class="form-group">
        <label class="form-label" for="email">Email Address</label>
        <div class="input-group">
            <i class="fas fa-envelope"></i>
            <input type="email" 
                   id="email" 
                   name="email" 
                   class="form-control" 
                   placeholder="Enter your registered email"
                   value="{{ old('email') }}"
                   required 
                   autofocus>
        </div>
        @error('email')
            <span class="error-message">{{ $message }}</span>
        @enderror
    </div>

    <button type="submit" class="btn-login">
        <i class="fas fa-paper-plane"></i> Send Reset Link
    </button>
</form>

<div class="auth-footer">
    <p>Remember your password? <a href="{{ route('login') }}">Back to Login</a></p>
</div>
@endsection
