@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-eye"></i> Account Details: {{ $account->name }}</h3>
        <div>
            <a href="{{ route('accounts.edit', $account) }}" class="btn btn-primary" style="margin-right: 0.5rem;">
                <i class="fas fa-edit"></i> Edit
            </a>
            <a href="{{ route('accounts.index') }}" class="btn btn-outline">
                <i class="fas fa-arrow-left"></i> Back
            </a>
        </div>
    </div>
    <div class="card-body">
        <!-- Account Info Cards -->
        <div class="form-row mb-4">
            <div class="form-group" style="flex: 1;">
                <div style="background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%); padding: 1.5rem; border-radius: 8px; height: 100%;">
                    <div style="font-size: 0.85rem; color: #6c757d; margin-bottom: 0.5rem;">Account Code</div>
                    <div style="font-size: 1.5rem; font-weight: 700; color: var(--primary-color);">{{ $account->code }}</div>
                </div>
            </div>
            <div class="form-group" style="flex: 2;">
                <div style="background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%); padding: 1.5rem; border-radius: 8px; height: 100%;">
                    <div style="font-size: 0.85rem; color: #6c757d; margin-bottom: 0.5rem;">Account Name</div>
                    <div style="font-size: 1.5rem; font-weight: 700;">{{ $account->name }}</div>
                </div>
            </div>
            <div class="form-group" style="flex: 1;">
                <div style="background: linear-gradient(135deg, #d4edda 0%, #c3e6cb 100%); padding: 1.5rem; border-radius: 8px; height: 100%;">
                    <div style="font-size: 0.85rem; color: #155724; margin-bottom: 0.5rem;">Current Balance</div>
                    <div style="font-size: 1.5rem; font-weight: 700; color: #155724;">Rs. {{ number_format($account->current_balance, 2) }}</div>
                </div>
            </div>
        </div>

        <!-- Account Details -->
        <div class="form-row">
            <div class="form-group" style="flex: 1;">
                <div style="border: 1px solid #dee2e6; border-radius: 8px; padding: 1rem;">
                    <h4 style="margin: 0 0 1rem 0; padding-bottom: 0.5rem; border-bottom: 1px solid #dee2e6;">
                        <i class="fas fa-info-circle"></i> Account Information
                    </h4>
                    <table style="width: 100%;">
                        <tr>
                            <td style="padding: 0.5rem 0; color: #6c757d; width: 40%;">Type:</td>
                            <td style="padding: 0.5rem 0; font-weight: 500;">
                                @php
                                    $typeLabels = ['asset' => 'Asset', 'liability' => 'Liability', 'equity' => 'Equity', 'income' => 'Income', 'expense' => 'Expense'];
                                    $badgeColors = ['asset' => '#28a745', 'liability' => '#dc3545', 'equity' => '#6f42c1', 'income' => '#17a2b8', 'expense' => '#fd7e14'];
                                @endphp
                                <span style="background-color: {{ $badgeColors[$account->type] ?? '#6c757d' }}; color: white; padding: 0.25rem 0.5rem; border-radius: 4px; font-size: 0.85rem;">
                                    {{ $typeLabels[$account->type] ?? ucfirst($account->type) }}
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td style="padding: 0.5rem 0; color: #6c757d;">Sub Type:</td>
                            <td style="padding: 0.5rem 0;">{{ $account->sub_type ? ucwords(str_replace('_', ' ', $account->sub_type)) : '-' }}</td>
                        </tr>
                        <tr>
                            <td style="padding: 0.5rem 0; color: #6c757d;">Parent Account:</td>
                            <td style="padding: 0.5rem 0;">
                                @if($account->parent)
                                    <a href="{{ route('accounts.show', $account->parent) }}">{{ $account->parent->code }} - {{ $account->parent->name }}</a>
                                @else
                                    <span style="color: #6c757d;">Root Account</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <td style="padding: 0.5rem 0; color: #6c757d;">Opening Balance:</td>
                            <td style="padding: 0.5rem 0;">
                                Rs. {{ number_format($account->opening_balance, 2) }}
                                <span style="font-size: 0.85rem; color: #6c757d;">({{ ucfirst($account->opening_type) }})</span>
                            </td>
                        </tr>
                        <tr>
                            <td style="padding: 0.5rem 0; color: #6c757d;">Status:</td>
                            <td style="padding: 0.5rem 0;">
                                @if($account->is_active)
                                    <span style="background-color: #28a745; color: white; padding: 0.2rem 0.5rem; border-radius: 4px; font-size: 0.8rem;">Active</span>
                                @else
                                    <span style="background-color: #6c757d; color: white; padding: 0.2rem 0.5rem; border-radius: 4px; font-size: 0.8rem;">Inactive</span>
                                @endif
                                @if($account->is_system)
                                    <span style="background-color: #ffc107; color: #212529; padding: 0.2rem 0.5rem; border-radius: 4px; font-size: 0.8rem; margin-left: 0.25rem;">System</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <td style="padding: 0.5rem 0; color: #6c757d;">Description:</td>
                            <td style="padding: 0.5rem 0;">{{ $account->description ?: '-' }}</td>
                        </tr>
                        <tr>
                            <td style="padding: 0.5rem 0; color: #6c757d;">Created:</td>
                            <td style="padding: 0.5rem 0;">{{ $account->created_at->format('d M Y, h:i A') }}</td>
                        </tr>
                        <tr>
                            <td style="padding: 0.5rem 0; color: #6c757d;">Last Updated:</td>
                            <td style="padding: 0.5rem 0;">{{ $account->updated_at->format('d M Y, h:i A') }}</td>
                        </tr>
                    </table>
                </div>
            </div>
            
            @if($account->children->count() > 0)
            <div class="form-group" style="flex: 1;">
                <div style="border: 1px solid #dee2e6; border-radius: 8px; padding: 1rem;">
                    <h4 style="margin: 0 0 1rem 0; padding-bottom: 0.5rem; border-bottom: 1px solid #dee2e6;">
                        <i class="fas fa-sitemap"></i> Sub Accounts ({{ $account->children->count() }})
                    </h4>
                    <table style="width: 100%;">
                        <thead>
                            <tr>
                                <th style="padding: 0.5rem; text-align: left;">Code</th>
                                <th style="padding: 0.5rem; text-align: left;">Name</th>
                                <th style="padding: 0.5rem; text-align: right;">Balance</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($account->children as $child)
                                <tr>
                                    <td style="padding: 0.5rem;">
                                        <a href="{{ route('accounts.show', $child) }}">{{ $child->code }}</a>
                                    </td>
                                    <td style="padding: 0.5rem;">{{ $child->name }}</td>
                                    <td style="padding: 0.5rem; text-align: right;">Rs. {{ number_format($child->current_balance, 2) }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
            @endif
        </div>

        <!-- Recent Transactions -->
        <div style="margin-top: 1.5rem; border: 1px solid #dee2e6; border-radius: 8px; padding: 1rem;">
            <h4 style="margin: 0 0 1rem 0; padding-bottom: 0.5rem; border-bottom: 1px solid #dee2e6;">
                <i class="fas fa-history"></i> Recent Transactions
                <span style="font-size: 0.85rem; font-weight: normal; color: #6c757d;">(Last 20)</span>
            </h4>
            
            @if($account->transactions->count() > 0)
                <div class="table-responsive">
                    <table>
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Reference</th>
                                <th>Description</th>
                                <th class="text-right">Debit</th>
                                <th class="text-right">Credit</th>
                                <th class="text-right">Balance</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php $runningBalance = $account->opening_balance; @endphp
                            @foreach($account->transactions->take(20) as $transaction)
                                @php
                                    if ($transaction->type == 'debit') {
                                        $runningBalance += $transaction->amount;
                                    } else {
                                        $runningBalance -= $transaction->amount;
                                    }
                                @endphp
                                <tr>
                                    <td>{{ \Carbon\Carbon::parse($transaction->date)->format('d M Y') }}</td>
                                    <td>{{ $transaction->reference }}</td>
                                    <td>{{ $transaction->description ?: '-' }}</td>
                                    <td class="text-right">
                                        @if($transaction->type == 'debit')
                                            Rs. {{ number_format($transaction->amount, 2) }}
                                        @else
                                            -
                                        @endif
                                    </td>
                                    <td class="text-right">
                                        @if($transaction->type == 'credit')
                                            Rs. {{ number_format($transaction->amount, 2) }}
                                        @else
                                            -
                                        @endif
                                    </td>
                                    <td class="text-right" style="font-weight: 500;">
                                        Rs. {{ number_format(abs($runningBalance), 2) }}
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                
                @if($account->transactions->count() > 20)
                    <div style="margin-top: 1rem; text-align: center;">
                        <a href="{{ route('reports.ledger', ['account_id' => $account->id]) }}" class="btn btn-outline">
                            <i class="fas fa-book"></i> View Full Ledger
                        </a>
                    </div>
                @endif
            @else
                <div style="text-align: center; padding: 2rem; color: #6c757d;">
                    <i class="fas fa-inbox" style="font-size: 2rem; opacity: 0.5; display: block; margin-bottom: 0.5rem;"></i>
                    <p style="margin: 0;">No transactions found for this account.</p>
                </div>
            @endif
        </div>
    </div>
</div>
@endsection
