@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-sitemap"></i> Chart of Accounts</h3>
        <a href="{{ route('accounts.create') }}" class="btn btn-primary">
            <i class="fas fa-plus"></i> New Account
        </a>
    </div>
    <div class="card-body">
        @if(session('success'))
            <div class="alert" style="background-color: #d4edda; border: 1px solid #c3e6cb; color: #155724; padding: 1rem; border-radius: 4px; margin-bottom: 1rem;">
                <i class="fas fa-check-circle"></i> {{ session('success') }}
            </div>
        @endif
        @if(session('error'))
            <div class="alert" style="background-color: #f8d7da; border: 1px solid #f5c6cb; color: #721c24; padding: 1rem; border-radius: 4px; margin-bottom: 1rem;">
                <i class="fas fa-exclamation-circle"></i> {{ session('error') }}
            </div>
        @endif

        <!-- Filters -->
        <form method="GET" action="{{ route('accounts.index') }}">
            <div class="form-row mb-4">
                <div class="form-group" style="flex: 0 0 200px;">
                    <label class="form-label">Filter by Type</label>
                    <select class="form-control" name="type" onchange="this.form.submit()">
                        <option value="">All Types</option>
                        @foreach($types as $key => $type)
                            <option value="{{ $key }}" {{ request('type') == $key ? 'selected' : '' }}>{{ $type['label'] }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="form-group" style="flex: 1;">
                    <label class="form-label">Search</label>
                    <input type="text" class="form-control" name="search" value="{{ request('search') }}" placeholder="Search by code or name...">
                </div>
                <div class="form-group" style="flex: 0 0 auto; display: flex; align-items: flex-end;">
                    <button type="submit" class="btn btn-outline" style="margin-right: 0.5rem;"><i class="fas fa-search"></i> Search</button>
                    <a href="{{ route('accounts.index') }}" class="btn btn-outline"><i class="fas fa-times"></i> Clear</a>
                </div>
            </div>
        </form>

        <!-- Summary Cards -->
        <div class="form-row mb-4">
            @foreach($types as $key => $type)
                @php
                    $typeAccounts = $groupedAccounts->get($key, collect([]));
                    $totalBalance = $typeAccounts->sum('current_balance');
                @endphp
                <div class="form-group" style="flex: 1;">
                    <div style="background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%); padding: 1rem; border-radius: 8px; text-align: center; border-left: 4px solid var(--primary-color);">
                        <div style="font-size: 0.85rem; color: #6c757d;">{{ $type['label'] }}</div>
                        <div style="font-size: 1.25rem; font-weight: 700; color: var(--primary-color);">{{ $typeAccounts->count() }}</div>
                        <div style="font-size: 0.75rem; color: #6c757d;">Rs. {{ number_format($totalBalance, 2) }}</div>
                    </div>
                </div>
            @endforeach
        </div>

        <div class="table-responsive">
            <table>
                <thead>
                    <tr>
                        <th>Code</th>
                        <th>Account Name</th>
                        <th>Type</th>
                        <th>Sub Type</th>
                        <th>Parent Account</th>
                        <th class="text-right">Opening</th>
                        <th class="text-right">Balance</th>
                        <th class="text-center">Status</th>
                        <th class="text-center">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($accounts as $account)
                        <tr>
                            <td><strong>{{ $account->code }}</strong></td>
                            <td>{{ $account->name }}</td>
                            <td>
                                @php
                                    $badgeColors = [
                                        'asset' => '#28a745',
                                        'liability' => '#dc3545',
                                        'equity' => '#6f42c1',
                                        'income' => '#17a2b8',
                                        'expense' => '#fd7e14'
                                    ];
                                @endphp
                                <span style="background-color: {{ $badgeColors[$account->type] ?? '#6c757d' }}; color: white; padding: 0.25rem 0.5rem; border-radius: 4px; font-size: 0.75rem;">
                                    {{ $types[$account->type]['label'] ?? ucfirst($account->type) }}
                                </span>
                            </td>
                            <td>{{ $account->sub_type ? ucwords(str_replace('_', ' ', $account->sub_type)) : '-' }}</td>
                            <td>{{ $account->parent ? $account->parent->name : '-' }}</td>
                            <td class="text-right">
                                Rs. {{ number_format($account->opening_balance, 2) }}
                                @if($account->opening_balance > 0)
                                    <span style="font-size: 0.7rem; color: #6c757d;">({{ ucfirst($account->opening_type) }})</span>
                                @endif
                            </td>
                            <td class="text-right" style="font-weight: 600;">
                                Rs. {{ number_format($account->current_balance, 2) }}
                            </td>
                            <td class="text-center">
                                @if($account->is_active)
                                    <span style="background-color: #28a745; color: white; padding: 0.2rem 0.5rem; border-radius: 4px; font-size: 0.7rem;">Active</span>
                                @else
                                    <span style="background-color: #6c757d; color: white; padding: 0.2rem 0.5rem; border-radius: 4px; font-size: 0.7rem;">Inactive</span>
                                @endif
                            </td>
                            <td class="text-center">
                                <a href="{{ route('accounts.show', $account) }}" class="btn btn-outline" style="padding: 0.25rem 0.5rem;" title="View">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="{{ route('accounts.edit', $account) }}" class="btn btn-outline" style="padding: 0.25rem 0.5rem;" title="Edit">
                                    <i class="fas fa-edit"></i>
                                </a>
                                @if(!$account->is_system)
                                <form action="{{ route('accounts.destroy', $account) }}" method="POST" style="display: inline;">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-outline" style="padding: 0.25rem 0.5rem; color: var(--danger-color);" onclick="return confirm('Are you sure you want to delete this account?')" title="Delete">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                                @endif
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="9" class="text-center text-muted" style="padding: 3rem;">
                                <i class="fas fa-folder-open" style="font-size: 3rem; display: block; margin-bottom: 1rem; opacity: 0.5;"></i>
                                <p style="margin: 0;">No accounts found. <a href="{{ route('accounts.create') }}">Create your first account</a></p>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <div style="margin-top: 1rem; display: flex; justify-content: space-between; align-items: center;">
            <span style="color: #6c757d;">Total: {{ $accounts->count() }} accounts</span>
        </div>
    </div>
</div>
@endsection
