@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-edit"></i> Edit Account: {{ $account->name }}</h3>
        <a href="{{ route('accounts.index') }}" class="btn btn-outline">
            <i class="fas fa-arrow-left"></i> Back
        </a>
    </div>
    <div class="card-body">
        @if($errors->any())
            <div style="background-color: #f8d7da; border: 1px solid #f5c6cb; color: #721c24; padding: 1rem; border-radius: 4px; margin-bottom: 1rem;">
                <strong><i class="fas fa-exclamation-triangle"></i> Please fix the following errors:</strong>
                <ul style="margin: 0.5rem 0 0 1.5rem;">
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        @if($account->is_system)
            <div style="background-color: #fff3cd; border: 1px solid #ffc107; color: #856404; padding: 1rem; border-radius: 4px; margin-bottom: 1rem;">
                <i class="fas fa-info-circle"></i> This is a system account. Some fields cannot be modified.
            </div>
        @endif

        <form action="{{ route('accounts.update', $account) }}" method="POST">
            @csrf
            @method('PUT')
            
            <div class="form-row">
                <div class="form-group">
                    <label class="form-label" for="type">Account Type <span class="text-danger">*</span></label>
                    <select class="form-control @error('type') is-invalid @enderror" 
                            id="type" name="type" required onchange="updateSubTypes()" {{ $account->is_system ? 'disabled' : '' }}>
                        <option value="">Select Type</option>
                        @foreach($types as $key => $type)
                            <option value="{{ $key }}" {{ old('type', $account->type) == $key ? 'selected' : '' }}>
                                {{ $type['label'] }}
                            </option>
                        @endforeach
                    </select>
                    @if($account->is_system)
                        <input type="hidden" name="type" value="{{ $account->type }}">
                    @endif
                    @error('type')
                        <span class="error-message">{{ $message }}</span>
                    @enderror
                </div>

                <div class="form-group">
                    <label class="form-label" for="sub_type">Sub Type</label>
                    <select class="form-control @error('sub_type') is-invalid @enderror" 
                            id="sub_type" name="sub_type">
                        <option value="">Select Sub Type</option>
                    </select>
                    @error('sub_type')
                        <span class="error-message">{{ $message }}</span>
                    @enderror
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label class="form-label" for="code">Account Code <span class="text-danger">*</span></label>
                    <input type="text" class="form-control @error('code') is-invalid @enderror" 
                           id="code" name="code" value="{{ old('code', $account->code) }}" 
                           placeholder="e.g., 1001" required {{ $account->is_system ? 'readonly' : '' }}>
                    @error('code')
                        <span class="error-message">{{ $message }}</span>
                    @enderror
                </div>

                <div class="form-group">
                    <label class="form-label" for="name">Account Name <span class="text-danger">*</span></label>
                    <input type="text" class="form-control @error('name') is-invalid @enderror" 
                           id="name" name="name" value="{{ old('name', $account->name) }}" 
                           placeholder="e.g., Cash in Hand" required>
                    @error('name')
                        <span class="error-message">{{ $message }}</span>
                    @enderror
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label class="form-label" for="parent_id">Parent Account</label>
                    <select class="form-control @error('parent_id') is-invalid @enderror" id="parent_id" name="parent_id">
                        <option value="">No Parent (Root Account)</option>
                        @foreach($parentAccounts as $parent)
                            <option value="{{ $parent->id }}" {{ old('parent_id', $account->parent_id) == $parent->id ? 'selected' : '' }}>
                                {{ $parent->code }} - {{ $parent->name }}
                            </option>
                        @endforeach
                    </select>
                    @error('parent_id')
                        <span class="error-message">{{ $message }}</span>
                    @enderror
                </div>

                <div class="form-group">
                    <label class="form-label" for="description">Description</label>
                    <input type="text" class="form-control" id="description" name="description" 
                           value="{{ old('description', $account->description) }}" placeholder="Optional description...">
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label class="form-label" for="opening_balance">Opening Balance</label>
                    <input type="number" class="form-control @error('opening_balance') is-invalid @enderror" 
                           id="opening_balance" name="opening_balance" 
                           value="{{ old('opening_balance', $account->opening_balance) }}" step="0.01" min="0">
                    @error('opening_balance')
                        <span class="error-message">{{ $message }}</span>
                    @enderror
                </div>

                <div class="form-group">
                    <label class="form-label" for="opening_type">Balance Type</label>
                    <select class="form-control @error('opening_type') is-invalid @enderror" id="opening_type" name="opening_type">
                        <option value="debit" {{ old('opening_type', $account->opening_type) == 'debit' ? 'selected' : '' }}>Debit (Dr)</option>
                        <option value="credit" {{ old('opening_type', $account->opening_type) == 'credit' ? 'selected' : '' }}>Credit (Cr)</option>
                    </select>
                    @error('opening_type')
                        <span class="error-message">{{ $message }}</span>
                    @enderror
                </div>
            </div>

            <div class="form-row">
                <div class="form-group" style="flex: 0 0 auto;">
                    <label class="form-label" style="display: block; margin-bottom: 0.75rem;">&nbsp;</label>
                    <label style="display: flex; align-items: center; gap: 0.5rem; cursor: pointer;">
                        <input type="checkbox" name="is_active" value="1" 
                               {{ old('is_active', $account->is_active) ? 'checked' : '' }}
                               style="width: 18px; height: 18px;">
                        <span>Active</span>
                    </label>
                </div>
            </div>

            <div style="background-color: #f8f9fa; padding: 1rem; border-radius: 4px; margin-top: 1rem; margin-bottom: 1rem;">
                <div class="form-row" style="margin-bottom: 0;">
                    <div class="form-group" style="margin-bottom: 0;">
                        <label class="form-label" style="color: #6c757d;">Current Balance</label>
                        <div style="font-size: 1.5rem; font-weight: 700; color: var(--primary-color);">
                            Rs. {{ number_format($account->current_balance, 2) }}
                        </div>
                    </div>
                    <div class="form-group" style="margin-bottom: 0;">
                        <label class="form-label" style="color: #6c757d;">Created At</label>
                        <div>{{ $account->created_at->format('d M Y, h:i A') }}</div>
                    </div>
                    <div class="form-group" style="margin-bottom: 0;">
                        <label class="form-label" style="color: #6c757d;">Last Updated</label>
                        <div>{{ $account->updated_at->format('d M Y, h:i A') }}</div>
                    </div>
                </div>
            </div>

            <div style="display: flex; gap: 0.5rem; margin-top: 1.5rem;">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> Update Account
                </button>
                <a href="{{ route('accounts.show', $account) }}" class="btn btn-outline">
                    <i class="fas fa-eye"></i> View
                </a>
                <a href="{{ route('accounts.index') }}" class="btn btn-outline">
                    Cancel
                </a>
            </div>
        </form>
    </div>
</div>

<script>
    const allSubTypes = @json($subTypes);
    const currentSubType = '{{ old('sub_type', $account->sub_type) }}';

    function updateSubTypes() {
        const typeSelect = document.getElementById('type');
        const subTypeSelect = document.getElementById('sub_type');
        const selectedType = typeSelect.value;
        
        // Clear current options
        subTypeSelect.innerHTML = '<option value="">Select Sub Type</option>';
        
        if (selectedType && allSubTypes[selectedType]) {
            const subTypes = allSubTypes[selectedType];
            for (const [key, value] of Object.entries(subTypes)) {
                const option = document.createElement('option');
                option.value = key;
                option.textContent = value;
                if (key === currentSubType) {
                    option.selected = true;
                }
                subTypeSelect.appendChild(option);
            }
        }
    }

    // Initialize on page load
    document.addEventListener('DOMContentLoaded', function() {
        updateSubTypes();
    });
</script>
@endsection
