<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Account;
use App\Models\Setting;

class DefaultAccountsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create default settings
        Setting::create([
            'company_name' => 'USMAN BILAL Enterprises',
            'company_address' => 'Faisalabad, Pakistan',
            'company_phone' => '+92-321-7838138',
            'currency_symbol' => 'Rs.',
            'financial_year_start' => '07-01',
            'current_year_start' => '2026-01-01',
            'current_year_end' => '2026-12-31',
        ]);

        // Default Chart of Accounts
        $accounts = [
            // Assets (1xxxx)
            ['code' => '10001', 'name' => 'Cash in Hand', 'type' => 'asset', 'sub_type' => 'cash', 'is_system' => true, 'opening_balance' => 50000],
            ['code' => '10002', 'name' => 'Petty Cash', 'type' => 'asset', 'sub_type' => 'cash', 'is_system' => true],
            ['code' => '11001', 'name' => 'HBL - Current Account', 'type' => 'asset', 'sub_type' => 'bank', 'is_system' => true, 'opening_balance' => 100000],
            ['code' => '11002', 'name' => 'MCB - Saving Account', 'type' => 'asset', 'sub_type' => 'bank', 'is_system' => true],
            ['code' => '12001', 'name' => 'Accounts Receivable', 'type' => 'asset', 'sub_type' => 'receivable', 'is_system' => true],
            ['code' => '13001', 'name' => 'Inventory - Raw Material', 'type' => 'asset', 'sub_type' => 'inventory', 'is_system' => true],
            ['code' => '13002', 'name' => 'Inventory - Finished Goods', 'type' => 'asset', 'sub_type' => 'inventory', 'is_system' => true],
            ['code' => '14001', 'name' => 'Machinery & Equipment', 'type' => 'asset', 'sub_type' => 'fixed_asset'],
            ['code' => '14002', 'name' => 'Furniture & Fixtures', 'type' => 'asset', 'sub_type' => 'fixed_asset'],
            ['code' => '14003', 'name' => 'Vehicles', 'type' => 'asset', 'sub_type' => 'fixed_asset'],

            // Liabilities (2xxxx)
            ['code' => '20001', 'name' => 'Accounts Payable', 'type' => 'liability', 'sub_type' => 'payable', 'is_system' => true],
            ['code' => '21001', 'name' => 'Bank Loan', 'type' => 'liability', 'sub_type' => 'loan'],
            ['code' => '22001', 'name' => 'Salaries Payable', 'type' => 'liability', 'sub_type' => 'accrued'],
            ['code' => '22002', 'name' => 'Utilities Payable', 'type' => 'liability', 'sub_type' => 'accrued'],

            // Equity (3xxxx)
            ['code' => '30001', 'name' => 'Owner Capital', 'type' => 'equity', 'sub_type' => 'capital', 'is_system' => true, 'opening_balance' => 500000, 'opening_type' => 'credit'],
            ['code' => '30002', 'name' => 'Retained Earnings', 'type' => 'equity', 'sub_type' => 'retained_earnings', 'is_system' => true],
            ['code' => '31001', 'name' => 'Owner Drawings', 'type' => 'equity', 'sub_type' => 'drawing'],

            // Income (4xxxx)
            ['code' => '40001', 'name' => 'Sales Revenue', 'type' => 'income', 'sub_type' => 'sales', 'is_system' => true],
            ['code' => '40002', 'name' => 'Sales - Raw Material', 'type' => 'income', 'sub_type' => 'sales'],
            ['code' => '40003', 'name' => 'Sales - Finished Goods', 'type' => 'income', 'sub_type' => 'sales'],
            ['code' => '41001', 'name' => 'Other Income', 'type' => 'income', 'sub_type' => 'other_income'],
            ['code' => '41002', 'name' => 'Discount Received', 'type' => 'income', 'sub_type' => 'other_income'],

            // Expenses (5xxxx)
            ['code' => '50001', 'name' => 'Purchases', 'type' => 'expense', 'sub_type' => 'purchase', 'is_system' => true],
            ['code' => '50002', 'name' => 'Purchase - Raw Material', 'type' => 'expense', 'sub_type' => 'purchase'],
            ['code' => '51001', 'name' => 'Salary Expense', 'type' => 'expense', 'sub_type' => 'salary'],
            ['code' => '51002', 'name' => 'Wages Expense', 'type' => 'expense', 'sub_type' => 'salary'],
            ['code' => '52001', 'name' => 'Rent Expense', 'type' => 'expense', 'sub_type' => 'rent'],
            ['code' => '53001', 'name' => 'Electricity Expense', 'type' => 'expense', 'sub_type' => 'utility'],
            ['code' => '53002', 'name' => 'Gas Expense', 'type' => 'expense', 'sub_type' => 'utility'],
            ['code' => '53003', 'name' => 'Water Expense', 'type' => 'expense', 'sub_type' => 'utility'],
            ['code' => '53004', 'name' => 'Telephone Expense', 'type' => 'expense', 'sub_type' => 'utility'],
            ['code' => '54001', 'name' => 'Transport Expense', 'type' => 'expense', 'sub_type' => 'transport'],
            ['code' => '54002', 'name' => 'Freight Expense', 'type' => 'expense', 'sub_type' => 'transport'],
            ['code' => '55001', 'name' => 'Office Supplies', 'type' => 'expense', 'sub_type' => 'office'],
            ['code' => '55002', 'name' => 'Printing & Stationery', 'type' => 'expense', 'sub_type' => 'office'],
            ['code' => '56001', 'name' => 'Discount Allowed', 'type' => 'expense', 'sub_type' => 'other_expense'],
            ['code' => '56002', 'name' => 'Bank Charges', 'type' => 'expense', 'sub_type' => 'other_expense'],
            ['code' => '56003', 'name' => 'Miscellaneous Expense', 'type' => 'expense', 'sub_type' => 'other_expense'],
        ];

        foreach ($accounts as $account) {
            Account::create(array_merge([
                'opening_balance' => 0,
                'opening_type' => 'debit',
                'current_balance' => $account['opening_balance'] ?? 0,
                'is_system' => false,
                'is_active' => true,
            ], $account));
        }

        $this->command->info('Default Chart of Accounts seeded successfully!');
        $this->command->info('Total accounts created: ' . count($accounts));
    }
}
